/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindIndexJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FindIndexJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String mdFormat;
    private String layout;
    private String interpretation;

    public String execute(NodeToken token) {
        String envFormat = token.getFullEnv().getAttribute("format");
        String envLayout = token.getFullEnv().getAttribute("layout");
        String envInterpretation = token.getFullEnv().getAttribute("interpretation");
        String format = this.handleOverride(token, "format", envFormat, this.getMdFormat());
        String layout = this.handleOverride(token, "layout", envLayout, this.getLayout());
        String interp = this.handleOverride(token, "interpretation", envInterpretation, this.getInterpretation());
        String mdRef = format + "-" + layout + "-" + interp;
        log.info((Object)("searching index for [" + mdRef + "]"));
        String indexId = this.findIndex(format, layout, interp);
        token.getEnv().setAttribute("index_id", indexId);
        if (indexId == null || indexId.isEmpty()) {
            log.info((Object)("no index was found for [" + mdRef + "]"));
            return "notFound";
        }
        log.info((Object)("index found for [" + mdRef + "]: " + indexId));
        return "found";
    }

    private String findIndex(String format, String layout, String interp) {
        String xquery = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType']return $x[.//METADATA_FORMAT = '" + format + "' and .//METADATA_FORMAT_LAYOUT='" + layout + "' and .//METADATA_FORMAT_INTERPRETATION = '" + interp + "']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            log.info((Object)("xquery: " + xquery));
            List ids = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
            log.info((Object)("found indexDS ids: " + ids));
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            if (ids.size() > 1) {
                throw new IllegalStateException("found more than one index of given format: " + format + ", layout: " + layout + ", interpretation: " + interp);
            }
            return (String)Iterables.getOnlyElement((Iterable)ids);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String handleOverride(NodeToken token, String name, String env, String override) {
        if (override != null) {
            token.getEnv().setAttribute(name, override);
        }
        return override != null ? override : env;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}

