/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.ContextDesc;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.ContextPart;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ProcessContextsJobNode
extends SimpleJobNode
implements ProgressJobNode {
    private String eprParam;
    private String contextObj;
    private ResultsetProgressProvider progressProvider;
    private String contextId;
    private String contextLabel;
    private String contextType;
    private static final Log log = LogFactory.getLog(ProcessContextsJobNode.class);
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private ProcessCountingResultSetFactory processCountingResultSetFactory;

    protected String execute(NodeToken token) throws Exception {
        ContextDesc context = new ContextDesc(this.contextId, this.contextLabel, this.contextType);
        String epr = token.getEnv().getAttribute(this.eprParam);
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        SAXReader reader = new SAXReader();
        for (String s : this.resultSetClientFactory.getClient(this.progressProvider.getEpr())) {
            Document doc = reader.read((Reader)new StringReader(s));
            for (Object o : doc.selectNodes("//fundingtree")) {
                Element treeNode = (Element)o;
                String openaireId = treeNode.valueOf("./*[starts-with(local-name(),'funding_level_')]/id");
                if (context.getDbEntries().containsKey(openaireId)) continue;
                log.info((Object)("Found funding: " + openaireId));
                context.getDbEntries().put(openaireId, treeNode.asXML());
                ContextPart part = this.calculatePart(treeNode.selectSingleNode(".//funding_level_0"));
                if (context.getCategories().containsKey(part.getId())) {
                    for (ContextPart p : part.getParts().values()) {
                        context.getCategories().get(part.getId()).addPart(p);
                    }
                    continue;
                }
                context.getCategories().put(part.getId(), part);
            }
        }
        token.getEnv().setTransientAttribute(this.contextObj, (Object)context);
        return Arc.DEFAULT_ARC;
    }

    private ContextPart calculatePart(Node node) {
        Element parent;
        String newId = this.contextId + "::" + StringUtils.substringAfter((String)node.valueOf("./id"), (String)"::");
        ContextPart part = new ContextPart(newId, node.valueOf("./description"));
        part.getParams().put("name", node.valueOf("./name"));
        part.getParams().put("openaireId", node.valueOf("./id"));
        part.getParams().put("class", node.valueOf("./class"));
        Element element = parent = node.getParent() != null ? node.getParent().getParent() : null;
        if (parent != null && parent.getName().startsWith("funding_level_")) {
            ContextPart p = this.calculatePart((Node)parent);
            part.getParts().put(p.getId(), p);
        }
        return part;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getContextObj() {
        return this.contextObj;
    }

    public void setContextObj(String contextObj) {
        this.contextObj = contextObj;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getContextLabel() {
        return this.contextLabel;
    }

    public void setContextLabel(String contextLabel) {
        this.contextLabel = contextLabel;
    }

    public String getContextType() {
        return this.contextType;
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }
}

