<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">
	
		<xsl:variable name="projectId" select="dnet:oafSplitId('project', //FIELD[@name = 'project'])" />
		<xsl:variable name="organizationId" select="dnet:oafSplitId('organization', //FIELD[@name = 'resporganization'])" />

		<ROWS>
			<xsl:if test="string-length($projectId) &gt; 0 and string-length($organizationId) &gt; 0">
			
				<xsl:variable name="projectorganization" 
						select="dnet:oafRel('projectOrganization', $projectId, $organizationId, //FIELD[not(@isNull)], 'hasParticipant', 'dnet:project_organization_relations')"/>
				<xsl:variable name="organizationproject" 
						select="dnet:oafRel('projectOrganization', $organizationId, $projectId, //FIELD[not(@isNull)], 'isParticipant', 'dnet:project_organization_relations')"/>	
			
				<ROW key="{$projectId}" columnFamily="projectOrganization_participation_hasParticipant">
					<QUALIFIER name="{$organizationId}" type="base64"><xsl:value-of select="$projectorganization"/></QUALIFIER>
				</ROW>
				<ROW key="{$organizationId}" columnFamily="projectOrganization_participation_isParticipant">
					<QUALIFIER name="{$projectId}" type="base64"><xsl:value-of select="$organizationproject"/></QUALIFIER>
				</ROW>
			</xsl:if>
		</ROWS>
	
	</xsl:template>

</xsl:stylesheet>
