<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	
	<xsl:param name="parentDatasourceId" />
	
	<xsl:template name="dateCorda">
		<xsl:param name="datename" />
		<xsl:param name="datevalue" />
		<FIELD name="{$datename}" type="date" format="dd-MMM-yyyy"><xsl:value-of select="concat(substring($datevalue, 1, 2),'-',substring($datevalue,3,3),'-',substring($datevalue,6,4))" /></FIELD>
	</xsl:template>
	
	<xsl:variable name="namespacePrefix" select="string('ec__________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::EC')" />
	
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
			
			<xsl:copy-of select=".//*[local-name()='header']"/>
			
			<metadata>
				<ROWS>
					<xsl:for-each select="//CoordinatorContactPerson">
						<xsl:if test="string-length(./PersonFirstName) &gt; 0 and string-length(./PersonLastName) &gt; 0">
							<xsl:variable name="personId" select="concat('corda_______::', ../ProjectId, '::', ./PersonFirstName, '_', ./PersonLastName)"></xsl:variable>
							<ROW table="persons">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$personId" /></FIELD>
								<FIELD name="firstname"><xsl:value-of select="./PersonFirstName" /></FIELD>
								<FIELD name="secondnames"><xsl:value-of select="./PersonLastName" /></FIELD>
								<FIELD name="fax"><xsl:value-of select="./ContactFax" /></FIELD>
								<FIELD name="email"><xsl:value-of select="./ContactEmail" /></FIELD>
								<FIELD name="phone"><xsl:value-of select="./ContactPhone" /></FIELD>
								<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
						</xsl:if>
					</xsl:for-each>
					
					<xsl:for-each select="//Project">

						<xsl:variable name="specificName">
							<xsl:choose>
								<xsl:when test="normalize-space(./ProjectSpecificProgram)">
									<xsl:value-of select="normalize-space(./ProjectSpecificProgram)"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="string('UNKNOWN')"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						
						<xsl:variable name="specificDesc" select="./ProjectSpecificProgramDescr" />
						<xsl:variable name="specificId" select="normalize-space(concat($funderID, '::FP7::', $specificName))"/>	

						<xsl:variable name="projectProgramName">
							<xsl:choose>
								<xsl:when test="normalize-space(./ProjectProgram)">
									<xsl:value-of select="normalize-space(./ProjectProgram)"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="string('UNKNOWN')"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<xsl:variable name="projectProgramDesc" select="./ProjectProgramDescr" />
						<xsl:variable name="projectProgramId" select="concat($funderID, '::FP7::', $specificName, '::', $projectProgramName)"/>
						<xsl:variable name="projectId" select="concat('corda_______::', normalize-space(./ProjectId))"/>
						
						<!-- 
						<ROW table="fundings">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$specificId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$specificId" /></FIELD>
							<FIELD name="name"><xsl:value-of select="$specificName" /></FIELD>
							<FIELD name="description"><xsl:value-of select="$specificDesc" /></FIELD>
							<FIELD name="semanticclass">ec:specificprogram</FIELD>
							<FIELD name="semanticscheme">ec:funding_typologies</FIELD>
						</ROW>
						
						<ROW table="fundings">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectProgramId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectProgramId" /></FIELD>
							<FIELD name="name"><xsl:value-of select="$projectProgramName" /></FIELD>
							<FIELD name="description"><xsl:value-of select="$projectProgramDesc" /></FIELD>
							<FIELD name="semanticclass">ec:program</FIELD>
							<FIELD name="semanticscheme">ec:funding_typologies</FIELD>
						</ROW>
						
						<ROW table="funding_funding">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($specificId, '@@corda_______::FP7')" /></FIELD>
							<FIELD name="funding1"><xsl:value-of select="$specificId" /></FIELD>
							<FIELD name="funding2">corda_______::FP7</FIELD>
							<FIELD name="semanticclass">ec:hasframeworkprogram</FIELD>
							<FIELD name="semanticscheme">ec:funding_relations</FIELD>
						</ROW>
						
						<ROW table="funding_funding">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectProgramId, '@@', $specificId)" /></FIELD>
							<FIELD name="funding1"><xsl:value-of select="$projectProgramId" /></FIELD>
							<FIELD name="funding2"><xsl:value-of select="$specificId" /></FIELD>
							<FIELD name="semanticclass">ec:hasspecificprogram</FIELD>
							<FIELD name="semanticscheme">ec:funding_relations</FIELD>
						</ROW>
						-->
						
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select="./ProjectId" /></FIELD>
							<FIELD name="acronym"><xsl:value-of select="./ProjectAcronym" /></FIELD>
							<FIELD name="title"><xsl:value-of select="./ProjectTitle" /></FIELD>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectStartDate"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectEndDate"></xsl:with-param>
							</xsl:call-template> 
							<FIELD name="call_identifier"><xsl:value-of select="./ProjectCallIdentifier" /></FIELD>
							<FIELD name="ec_sc39" type="boolean"><xsl:value-of select="./SpecialClause39" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="contracttypeclass"><xsl:value-of select="./ProjectFundingScheme" /></FIELD>
							<FIELD name="contracttypescheme">ec:FP7contractTypes</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="websiteurl"><xsl:value-of select="./ProjectInternetAddress" /></FIELD>
							<FIELD name="optional1"><xsl:value-of select="./ProjectSubFundingScheme" /></FIELD>
							<FIELD name="optional2"><xsl:value-of select="./ProjectCallWebpageUrl" /></FIELD>
						</ROW>
						
						<!-- 
						<ROW table="project_funding">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectProgramId, '@@', $projectId)" /></FIELD>
							<FIELD name="funding"><xsl:value-of select="$projectProgramId" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectStartDate"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectEndDate"></xsl:with-param>
							</xsl:call-template> 
							<FIELD name="semanticclass"><xsl:value-of select="./ProjectFundingScheme" /></FIELD>
							<FIELD name="semanticscheme">ec:FP7contractTypes</FIELD>
						</ROW>
						-->
						
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectProgramId, '@@', $projectId)" /></FIELD>
							<FIELD name="funding"><xsl:value-of select="$projectProgramId" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">startdate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectStartDate"></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="dateCorda">
								<xsl:with-param name="datename">enddate</xsl:with-param>
								<xsl:with-param name="datevalue" select="./ProjectEndDate"></xsl:with-param>
							</xsl:call-template> 
							<FIELD name="semanticclass"><xsl:value-of select="./ProjectFundingScheme" /></FIELD>
							<FIELD name="semanticscheme">ec:FP7contractTypes</FIELD>
						</ROW>
					</xsl:for-each>
					
					<xsl:for-each select="//OrganisationParticipant">
						<xsl:variable name="organizationId" select="concat('corda_______::', ./OrganisationPIC)" />
						<xsl:variable name="projectId" select="concat('corda_______::', normalize-space(../ProjectId))" />
						<xsl:variable name="whitelist" select="'0123456789'"/>
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$organizationId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$organizationId" /></FIELD>
							<FIELD name="legalshortname"><xsl:value-of select="./OrganisationShortName" /></FIELD>
							<FIELD name="legalname"><xsl:value-of select="./OrganisationLegalName" /></FIELD>
							<FIELD name="websiteurl"><xsl:value-of select="./OrganisationWebPage" /></FIELD>
							<FIELD name="ec_legalbody" type="boolean"><xsl:value-of select="./PublicBody" /></FIELD>
							<FIELD name="ec_legalperson" type="boolean"><xsl:value-of select="./LegalPerson" /></FIELD>
							<FIELD name="ec_nonprofit" type="boolean"><xsl:value-of select="./NonProfit" /></FIELD>
							<FIELD name="ec_researchorganization" type="boolean"><xsl:value-of select="./ResearchOrganisation" /></FIELD>
							<FIELD name="ec_highereducation" type="boolean"><xsl:value-of select="./HigherEducation" /></FIELD>
							<FIELD name="ec_internationalorganizationeurinterests" type="boolean"><xsl:value-of select="./InternationalOrgEurInterest" /></FIELD>
							<FIELD name="ec_internationalorganization" type="boolean"><xsl:value-of select="./InternationalOrgEurInterest" /></FIELD>
							<FIELD name="ec_enterprise" type="boolean"><xsl:value-of select="./Enterprise" /></FIELD>
							<FIELD name="ec_smevalidated" type="boolean"><xsl:value-of select="./SMEValidated" /></FIELD>
							<FIELD name="countryclass"><xsl:value-of select="./OrganisationCountry" /></FIELD>
							<FIELD name="countryscheme">dnet:countries</FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						</ROW>
						
						<ROW table="project_organization">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select='concat($projectId, "@@", $organizationId)' /></FIELD>
							<xsl:choose>
								<xsl:when test="string-length(translate(./ParticipantOrder, $whitelist, '')) &gt; 0" > 
									<FIELD name="participantnumber" type="int">9999</FIELD>
								</xsl:when>
								<xsl:otherwise>
									<FIELD name="participantnumber" type="int"><xsl:value-of select="./ParticipantOrder" /></FIELD>
								</xsl:otherwise>
							</xsl:choose>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="resporganization"><xsl:value-of select="$organizationId" /></FIELD>
							<xsl:choose>
								<xsl:when test="./ParticipantOrder = 1">
									<FIELD name="contactperson"><xsl:value-of select="concat($projectId, '::', ..//CoordinatorContactPerson/PersonFirstName, '_', ../CoordinatorContactPerson/PersonLastName)"></xsl:value-of></FIELD>
									<FIELD name="semanticclass">coordinator</FIELD>
								</xsl:when>
								<xsl:otherwise>
									<FIELD name="contactperson"></FIELD>
									<FIELD name="semanticclass">participant</FIELD>
								</xsl:otherwise>
							</xsl:choose>
							<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
						</ROW>
					</xsl:for-each>		
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
