CREATE TYPE IIS_STATUS AS ENUM ('unsolved', 'solved');
CREATE TYPE STATUS AS ENUM ('pending', 'accepted', 'refused', 'deleted');

CREATE TABLE blacklist (

	userid character varying(255) NOT NULL,
	semantic_class character varying(255) NOT NULL,
	semantic_scheme character varying(255) NOT NULL,
	hbase_relation_type_encoding character varying(255) NOT NULL,
	provenance character varying(255) NOT NULL,
	iis_module character varying(255) NOT NULL,
	iis_module_profile character varying(255),
	
	iis_status IIS_STATUS NOT NULL,
	status STATUS NOT NULL,

	source_object character varying(255) NOT NULL,
	target_object character varying(255) NOT NULL,

	original_source_objects character varying(255) ARRAY,
	original_target_objects character varying(255) ARRAY,

	creation_time timestamp default now(),
	last_update_time timestamp default now(),
	
	note text,
	ticket_id character varying(255)
);

-- https://issue.openaire.research-infrastructures.eu/issues/1245
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'corda_______::fda6a1c19dac47508b6fb619518328c7', '1245');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od_______908::a47e1c3ede9a21ee5278a2e5c338d69b', 'corda_______::189ff31d637eaaeaf4d3584dc490b1cf', '1245');
			
-- https://issue.openaire.research-infrastructures.eu/issues/1360			
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od________18::062cf091d5c7a7d730001c34177042e3', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');
INSERT INTO blacklist(userid, semantic_class, semantic_scheme, hbase_relation_type_encoding, provenance, iis_module, iis_status, status, source_object, target_object, ticket_id) 
			VALUES('unknown', 'isProducedBy', 'dnet:result_project_relations', 'resultProject_outcome_isProducedBy', 'iis', 'iis::document_referencedProjects', 'unsolved', 'accepted', 'od________18::062cf091d5c7a7d730001c34177042e3', 'corda_______::9826e8aba3e8f3a2a46545cf341838a8', '1360');
			