<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="namespacePrefix" select="string('nsf_________')" />
	
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length(normalize-space(.//AwardTitle)) &gt; 0 and string-length(normalize-space(.//AwardID)) &gt; 0">
						
						<xsl:variable name="projectId" select="concat($namespacePrefix, '::', normalize-space(.//AwardID))" />
						<xsl:variable name="orgId" select="concat($namespacePrefix, '::', translate(normalize-space(.//Institution/Name), ' ,.', '___'))" />
						<xsl:variable name="startDate" select=".//AwardEffectiveDate"/>
						<xsl:variable name="endDate" select=".//AwardExpirationDate"/>
												
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select=".//AwardID"/></FIELD>
							<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
							<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of  select="$endDate"/></FIELD>
							<FIELD name="title"><xsl:value-of select=".//AwardTitle" /></FIELD>
							<FIELD name="contracttypeclass"><xsl:value-of select=".//AwardInstrument/Value"/></FIELD>
							<FIELD name="contracttypescheme">nsf:contractTypes</FIELD>
							<FIELD name="acronym"> </FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<!-- <FIELD name="???"><xsl:value-of select=".//AbstractNarration" /></FIELD> -->
						</ROW>
	
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$orgId" /></FIELD>
							<FIELD name="legalname"><xsl:value-of select=".//Institution/Name" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<xsl:if test="string-length(normalize-space(.//Institution/CountryName)) &gt; 0">
								<FIELD name="countryclass"><xsl:value-of select=".//Institution/CountryName" /></FIELD>
							</xsl:if>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="optional1"><xsl:value-of select=".//Institution/CityName" /></FIELD>
							<FIELD name="optional2"><xsl:value-of select=".//Institution/StreetAddress" /></FIELD>
						</ROW>					
						
						
						<xsl:for-each select=".//Investigator[./RoleCode='Principal Investigator'] | .//Investigator[./RoleCode='Co-Principal Investigator'] | .//Investigator[./RoleCode='Former Principal Investigator'] | .//Investigator[./RoleCode='Former Co-Principal Investigator']">
							<xsl:if test="position() = 1">
								<xsl:variable name="personId" select="concat($projectId, '::', translate(concat(./FirstName, ' ', .//LastName), ' ,.', '___'))" />
								<ROW table="persons">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personId" /></FIELD>
									<FIELD name="id"><xsl:value-of select="$personId" /></FIELD>
									<FIELD name="firstname"><xsl:value-of select="./FirstName" /></FIELD>
									<FIELD name="secondnames"><xsl:value-of select="./LastName" /></FIELD>
									<FIELD name="email"><xsl:value-of select="./EmailAddress" /></FIELD>
									<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
									<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
									<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
									<FIELD name="optional1"><xsl:value-of select="./RoleCode" /></FIELD>
								</ROW>
							</xsl:if>						
						</xsl:for-each>
	
						<ROW table="project_organization">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectId, '@@', $orgId)" /></FIELD>
							<FIELD name="participantnumber" type="int">1</FIELD>
							<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
							<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="resporganization"><xsl:value-of select="$orgId" /></FIELD>
							<xsl:for-each select=".//Investigator[./RoleCode='Principal Investigator'] | .//Investigator[./RoleCode='Co-Principal Investigator'] | .//Investigator[./RoleCode='Former Principal Investigator'] | .//Investigator[./RoleCode='Former Co-Principal Investigator']">
								<xsl:if test="position() = 1">
									<FIELD name="contactperson"><xsl:value-of select="concat($projectId, '::', translate(concat(./FirstName, ' ', .//LastName), ' ,.', '___'))" /></FIELD>
								</xsl:if>
							</xsl:for-each>
							<FIELD name="semanticclass">coordinator</FIELD>
							<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
						</ROW>
						
						<xsl:for-each select=".//FoaInformation">
							<xsl:variable name="subjectId" select="concat($namespacePrefix, '::', normalize-space(./Code))"/>
														
							<ROW table="subjects">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$subjectId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$subjectId" /></FIELD>
								<FIELD name="name"><xsl:value-of select="./Name" /></FIELD>
								<FIELD name="semanticclass">nsf:fieldOfApplication</FIELD>
								<FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD>
							</ROW>
	
							<ROW table="project_subject">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectId, '@@', $subjectId)" /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="subject"><xsl:value-of select="$subjectId" /></FIELD>
							</ROW>
						</xsl:for-each>
						
						<xsl:for-each select=".//ProgramElement">
							<xsl:if test="string-length(normalize-space(./Code)) &gt; 0">
								<xsl:variable name="fundingId" select="concat($namespacePrefix, '::NSF::PEC::', normalize-space(./Code))" />
								<ROW table="project_fundingpath">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId,'@@', $projectId)" /></FIELD>
									<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
									<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
									<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
									<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
								</ROW>
							</xsl:if>
						</xsl:for-each>

						<xsl:for-each select=".//ProgramReference">
							<xsl:if test="string-length(normalize-space(./Code)) &gt; 0">
								<xsl:variable name="fundingId" select="concat($namespacePrefix, '::NSF::PRC::', normalize-space(./Code))"/>
								<ROW table="project_fundingpath">
									<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId,'@@', $projectId)" /></FIELD>
									<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
									<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
									<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
									<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
								</ROW>
							</xsl:if>
						</xsl:for-each>

					</xsl:if>
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
	
</xsl:stylesheet>
