<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('nsf_________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::NSF')" />

	<xsl:template match="/">
		<fundings>
			<xsl:for-each select=".//ProgramElement">
				<xsl:call-template name="addFundingTree">
					<xsl:with-param name="parentName" select="string('PEC')" />
					<xsl:with-param name="parentDesc" select="string('NSF Program Element Codes')" />
				</xsl:call-template>
			</xsl:for-each>
			<xsl:for-each select=".//ProgramReference">
				<xsl:call-template name="addFundingTree">
					<xsl:with-param name="parentName" select="string('PRC')" />
					<xsl:with-param name="parentDesc" select="string('NSF Program Reference Codes')" />
				</xsl:call-template>
			</xsl:for-each>
		</fundings>
	</xsl:template>

	<xsl:template name="addFundingTree">
		<xsl:param name="parentName" />
		<xsl:param name="parentDesc" />

		<xsl:if test="string-length(normalize-space(./Code)) &gt; 0">
			<fundingtree>
				<funder>
					<id><xsl:value-of select="$funderID" /></id>
					<shortname>NSF</shortname>
					<name>National Science Foundation</name>
					<jurisdiction>US</jurisdiction>
				</funder>
				<funding_level_1>
					<id><xsl:value-of select="concat($funderID, '::', $parentName, '::', normalize-space(./Code))" /></id>
					<xsl:choose>
						<xsl:when test="string-length(normalize-space(./Text)) &gt; 0">
							<description><xsl:value-of select="./Text" /></description>
							<name><xsl:value-of select="./Text" /></name>
						</xsl:when>
						<xsl:otherwise>
							<description><xsl:value-of select="./Code" /></description>
							<name><xsl:value-of select="./Code" /></name>
						</xsl:otherwise>
					</xsl:choose>
					<parent>
						<funding_level_0>
							<id><xsl:value-of select="concat($funderID, '::', $parentName)" /></id>
							<description><xsl:value-of select="$parentDesc" /></description>
							<name><xsl:value-of select="$parentName" /></name>
							<parent />
							<class>nsf:fundingStream</class>
						</funding_level_0>
					</parent>
					<class>nsf:fundingStream</class>
				</funding_level_1>
			</fundingtree>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
