package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.base.Joiner;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.IndentXmlString;

public class ContextLoader {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ContextLoader.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String xquery;

	@Resource
	private UniqueServiceLocator serviceLocator;

	public String load() throws ISLookUpException {

		log.info("loading ContextDSResources: " + getXquery());

		StringBuilder sb = new StringBuilder("<ContextDSResources>");
		Joiner.on("").appendTo(sb, serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery()));
		sb.append("</ContextDSResources>");

		log.debug("got ContextDSResources: \n" + IndentXmlString.apply(sb.toString()));

		return sb.toString();
	}

	public String getXquery() {
		return xquery;
	}

	@Required
	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}

}
