package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import java.io.StringWriter;
import java.util.Map;
import java.util.Map.Entry;

import com.google.common.collect.Maps;

public class HostedByCounters {
	private Map<String, Integer> counters = Maps.newHashMap();
	
	public void increaseCounter(final String dsId) {
		int val = counters.containsKey(dsId) ? counters.get(dsId) + 1 : 1;
		counters.put(dsId, val);
	}
	
	public Map<String, Integer> getCounters() {
		return counters;
	}

	@Override
	public String toString() {
		final StringWriter sw = new StringWriter();
		sw.append("\n");
		sw.append("**************************************************\n");
		for (Entry<String, Integer> e : counters.entrySet()) {
			sw.append(e.getKey());
			sw.append(" : ");
			sw.append(Integer.toString(e.getValue()));
			sw.append("\n");
		}
		sw.append("**************************************************\n");
		return sw.toString();
	}
}
