package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindExistingRepositoriesJobNode extends SimpleJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String existingReposParam = "existingRepos";

	@Override
	protected String execute(final NodeToken token) throws Exception {
		String xquery =
				"for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') " +
						"return concat (" +
						"$x//RESOURCE_IDENTIFIER/@value, " +
						"'@@@', " +
						"$x//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value)";
		final List<String> list = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);

		final Map<String, String> map = Maps.newHashMap();
		for (String s : list) {
			String[] arr = s.split("@@@");
			if (arr.length == 2) {
				map.put(arr[1], arr[0]);
			}
		}
		token.getEnv().setTransientAttribute(getExistingReposParam(), map);

		return Arc.DEFAULT_ARC;
	}

	public String getExistingReposParam() {
		return existingReposParam;
	}

	public void setExistingReposParam(final String existingReposParam) {
		this.existingReposParam = existingReposParam;
	}

}
