/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api.objects;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.msro.openaireplus.api.SinglePublicationSubmitterUtils;
import eu.dnetlib.msro.openaireplus.api.objects.DatasourceEntry;
import eu.dnetlib.msro.openaireplus.api.objects.PidEntry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.tools.generic.EscapeTool;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class PublicationEntry {
    private String originalId;
    private String title;
    private List<String> authors = new ArrayList<String>();
    private String publisher;
    private String description;
    private String language;
    private List<PidEntry> pids = new ArrayList<PidEntry>();
    private String licenseCode;
    private String embargoEndDate;
    private String resourceType;
    private String url;
    private String collectedFromId;
    private String hostedById;
    private List<String> contexts = new ArrayList<String>();
    private List<String> linksToProjects = new ArrayList<String>();
    private static long last_cache_update = 0L;
    private static final Map<String, Map<String, String>> cached_vocabularies = new HashMap<String, Map<String, String>>();
    private static final Map<String, DatasourceEntry> cached_datasources = new HashMap<String, DatasourceEntry>();
    private static final Map<String, String> cached_contexts = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(PublicationEntry.class);

    public String getEmbargoEndDate() {
        return this.embargoEndDate;
    }

    public void setEmbargoEndDate(String embargoEndDate) {
        this.embargoEndDate = embargoEndDate;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<PidEntry> getPids() {
        return this.pids;
    }

    public void setPids(List<PidEntry> pids) {
        this.pids = pids;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCollectedFromId() {
        return this.collectedFromId;
    }

    public void setCollectedFromId(String collectedFromId) {
        this.collectedFromId = collectedFromId;
    }

    public String getHostedById() {
        return this.hostedById;
    }

    public void setHostedById(String hostedById) {
        this.hostedById = hostedById;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<String> contexts) {
        this.contexts = contexts;
    }

    public List<String> getLinksToProjects() {
        return this.linksToProjects;
    }

    public void setLinksToProjects(List<String> linksToProjects) {
        this.linksToProjects = linksToProjects;
    }

    public String asOafRecord(VelocityEngine ve, ISLookUpService lookupService, String oafSchemaLocation) throws Exception {
        DatasourceEntry collectedFromEntry = PublicationEntry.getDatasourceInfo(this.collectedFromId, lookupService);
        DatasourceEntry hostedByEntry = PublicationEntry.getDatasourceInfo(this.hostedById, lookupService);
        String objId = collectedFromEntry.getPrefix() + "::" + Hashing.md5((String)this.originalId);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("esc", new EscapeTool());
        model.put("util", new SinglePublicationSubmitterUtils(lookupService));
        model.put("pub", this);
        model.put("objIdentifier", objId);
        model.put("oafSchemaLocation", oafSchemaLocation);
        model.put("licenses", PublicationEntry.getVocabulary("dnet:access_modes", lookupService));
        model.put("resourceTypes", PublicationEntry.getVocabulary("dnet:publication_resource", lookupService));
        model.put("pidTypes", PublicationEntry.getVocabulary("dnet:pid_types", lookupService));
        model.put("languages", PublicationEntry.getVocabulary("dnet:languages", lookupService));
        model.put("contexts", PublicationEntry.getContexts(lookupService));
        model.put("dateOfCollection", new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date()));
        model.put("collectedFrom", collectedFromEntry);
        model.put("hostedBy", hostedByEntry);
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)ve, (String)"/eu/dnetlib/msro/openaireplus/api/indexRecord.xml.vm", (String)"UTF-8", model);
    }

    private static synchronized DatasourceEntry getDatasourceInfo(String dsId, ISLookUpService lookupService) throws ISLookUpException {
        if (StringUtils.isBlank((String)dsId)) {
            return new DatasourceEntry("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", "Unknown Repository", "unknown_____");
        }
        if (!cached_datasources.containsKey(dsId)) {
            String query = "collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')//CONFIGURATION[./DATASOURCE_ORIGINAL_ID='" + dsId + "']/concat(./OFFICIAL_NAME, ' @@@ ', .//FIELD/value[../key='NamespacePrefix'])";
            String s = lookupService.getResourceProfileByQuery(query);
            String[] arr = s.split("@@@");
            DatasourceEntry ds = new DatasourceEntry(dsId, arr[0].trim(), arr[1].trim());
            if (StringUtils.isBlank((String)ds.getName()) || StringUtils.isBlank((String)ds.getPrefix())) {
                log.error((Object)("Invalid datasource id: " + dsId));
                throw new ISLookUpException("Invalid datasource id: " + dsId);
            }
            cached_datasources.put(dsId, ds);
        }
        return cached_datasources.get(dsId);
    }

    private static synchronized Map<String, String> getVocabulary(String voc, ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update < TimeUnit.MINUTES.toMillis(15L) && cached_vocabularies.containsKey(voc)) {
            return cached_vocabularies.get(voc);
        }
        String query = "collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code='" + voc + "']//TERM/concat(@code, ' @@@ ', @english_name)";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : lookupService.quickSearchProfile(query)) {
            String[] arr = s.split("@@@");
            map.put(arr[0].trim(), arr[1].trim());
        }
        cached_vocabularies.put(voc, map);
        last_cache_update = DateUtils.now();
        return map;
    }

    private static synchronized Map<String, String> getContexts(ISLookUpService lookupService) throws ISLookUpException {
        if (DateUtils.now() - last_cache_update > TimeUnit.MINUTES.toMillis(15L) || cached_contexts.isEmpty()) {
            String query = "collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)";
            cached_contexts.clear();
            for (String s : lookupService.quickSearchProfile("collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')[.//context/@type='community']//*[name()='context' or name()='category' or name()='concept']/concat(@id, ' @@@ ', @label)")) {
                String[] arr = s.split("@@@");
                cached_contexts.put(arr[0].trim(), arr[1].trim());
            }
            last_cache_update = DateUtils.now();
        }
        return cached_contexts;
    }
}

