package eu.dnetlib.msro.openaireplus.workflows.nodes.stats;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;

/**
 * Ask the StatsManagerService to copy a cache of a portal to another portal cache.
 * <p>
 * The source portal is specified in the BB parameter <code>StatsManagerServiceBBAction.MIGRATE_CACHE.getSourcePortalParamName()</code>.
 * </p>
 * <p>
 * The target portal is specified in the BB parameter <code>StatsManagerServiceBBAction.MIGRATE_CACHE.getTargetPortalParamName()</code>
 * </p>
 * 
 * @author alessia
 * 
 */
public class MigrateStatsCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(MigrateStatsCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * BB parameter defining which is the portal with the source cache to migrate.
	 */
	private String sourcePortal;

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.MIGRATE_CACHE.action());
		if (StringUtils.isBlank(sourcePortal)) throw new MSROException("Parameter sourcePortal required to migrate the cache");
		job.getParameters().put(StatsManagerServiceBBAction.MIGRATE_CACHE.getSourcePortalParamName(), sourcePortal);
		String targetPortal = getPortalName(token);
		if (StringUtils.isNotBlank(targetPortal)) {
			job.getParameters().put(StatsManagerServiceBBAction.MIGRATE_CACHE.getTargetPortalParamName(), targetPortal);
		} else {
			log.warn(StatsManagerServiceBBAction.MIGRATE_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}

	}
	
	public String getSourcePortal() {
		return sourcePortal;
	}

	public void setSourcePortal(final String sourcePortal) {
		this.sourcePortal = sourcePortal;
	}
}
