 <NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="SELECT_MODE"/>
	</ARCS>
</NODE>

<NODE name="SELECT_MODE" type="Selection">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="selection" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">INCREMENTAL</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="DropContentObjectStore" name="REFRESH" />
		<ARC to="findMdStore" name="INCREMENTAL" />
	</ARCS>
</NODE>

<NODE name="DropContentObjectStore" type="DropContentObjectStore">
	<DESCRIPTION>Drop content on the object Store</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="objectstoreId" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="findMdStore"/>
	</ARCS>
</NODE>

<NODE name="findMdStore" type="RetrieveMdStoreId">
	<DESCRIPTION>Find MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>		
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchTransformed"/>
	</ARCS>
</NODE>

<NODE name="fetchTransformed" type="FetchMultipleMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>		
		<PARAM required="true" type="string" name="eprParam" managedBy="system">clean_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="retrieveURL"/>
	</ARCS>
</NODE>

<NODE name="retrieveURL" type="RetrieveURLS">
	<DESCRIPTION>Retrieve URL To Download from MDStore</DESCRIPTION>
	<PARAMETERS>		
		<PARAM required="true" type="string" name="xpath" managedBy="user">//*[local-name()='metadata']//*[local-name()='identifier']/text()</PARAM>
		<PARAM required="true" type="string" name="xpathOpenAccess" managedBy="user">//*[local-name()='metadata']//*[local-name()='accessrights']/text()</PARAM>
		<PARAM required="true" type="string" name="xpathEmbargoDate" managedBy="user">//*[local-name()='metadata']//*[local-name()='embargoenddate']/text()</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">clean_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">item_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="downloadRecords"/>
	</ARCS>
</NODE>


<NODE name="downloadRecords" type="DownloadFromMetadataOpenaire">
	<DESCRIPTION>Download records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputeprParam" managedBy="system">item_epr</PARAM>
		<PARAM required="true" type="string" name="objectStoreID" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>
		<PARAM required="true" type="string" name="plugin" managedBy="user" function="obtainValues('listDownloadPlugins', {});"></PARAM>
		<PARAM required="false" type="string" name="basepath" managedBy="user"></PARAM>
		<PARAM required="true" type="string" name="protocol" managedBy="user" function="validValues(['HTTP', 'HTTPS', 'FTP', 'File_System', 'FTPS'])"></PARAM>
		<PARAM required="true" type="string" name="mimeType" managedBy="user" function="validValues(['pdf', 'application/pdf', 'xml', 'file::WoS', 'text', 'text/plain','text/html'])"></PARAM>
		<PARAM required="false" type="string" name="regularExpression" managedBy="user"></PARAM>
		<PARAM required="false" type="int" name="numberOfThreads" managedBy="user">5</PARAM>
		<PARAM required="false" type="int" name="connectTimeoutMs" managedBy="user">60000</PARAM>
		<PARAM required="false" type="int" name="readTimeoutMs" managedBy="user">60000</PARAM>
		<PARAM required="false" type="int" name="sleepTimeMs" managedBy="user">0</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="updateSizeObjectStore"/>
	</ARCS>
</NODE>

<NODE name="updateSizeObjectStore" type="UpdateObjectStoreSize">
	<DESCRIPTION>Download records</DESCRIPTION>
	<PARAMETERS>		
		<PARAM required="true" type="string" name="objectStoreIdParam" managedBy="system" category="OBJECTSTORE_ID">$params.("objs_id")$</PARAM>				
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_INFO" type="ObjectStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="objId" managedBy="system">$params.("objs_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_download_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_download_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForObjId" managedBy="system">last_download_objId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
