<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0"
                exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('wt__________')"/>
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::WT')"/>

	<xsl:template match="/">
		<xsl:variable name="funding">
			<xsl:choose>
				<xsl:when test="normalize-space(.//Grant/Stream)">
					<xsl:value-of select="normalize-space(.//Grant/Stream)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="string('UNKNOWN')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID"/>
				</id>
				<shortname>WT</shortname>
				<name>Wellcome Trust</name>
				<jurisdiction></jurisdiction>
			</funder>
			<funding_level_0>
				<id>
					<xsl:value-of select="concat($funderID, '::', $funding)"/>
				</id>
				<description>
					<xsl:value-of select="$funding"/>
				</description>
				<name>
					<xsl:value-of select="$funding"/>
				</name>
				<parent></parent>
				<class>wt:fundingStream</class>
			</funding_level_0>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
