/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.openaireplus.workflows.nodes.hostedby.HostedByCounters;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpsertHostedByApisJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(UpsertHostedByApisJobNode.class);
    private static final String HOSTED_BY_COMPLIANCE = "hostedBy";
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String countersParam;
    private String mdId;
    public static final String extraFieldsForTotal = "last_aggregation_total";
    public static final String extraFieldForDate = "last_aggregation_date";
    public static final String extraFieldForMdId = "last_aggregation_mdId";

    protected String execute(NodeToken token) throws Exception {
        HostedByCounters counters = (HostedByCounters)token.getEnv().getTransientAttribute(this.countersParam);
        DatasourceManagerService dsManager = (DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class);
        String date = DateUtils.now_ISO8601();
        String namespacePrefix = token.getEnv().getAttribute("namespacePrefix");
        log.info((Object)counters);
        for (Map.Entry<String, Integer> e : counters.getCounters().entrySet()) {
            this.updateHostedByApi(dsManager, e.getKey(), namespacePrefix, date, e.getValue());
        }
        return Arc.DEFAULT_ARC;
    }

    private void updateHostedByApi(DatasourceManagerService dsManager, String dsId, String namepsacePrefix, String date, int size) {
        log.info((Object)("Verifying hostedBy api in ds: " + dsId));
        try {
            DatasourceDesc ds = dsManager.getDatasource(dsId);
            for (IfaceDesc iface : ds.getInterfaces()) {
                if (!HOSTED_BY_COMPLIANCE.equals(iface.getCompliance())) continue;
                return;
            }
            IfaceDesc iface = new IfaceDesc();
            iface.setId("api_________::" + dsId + "::hostedBy");
            iface.setTypology(ds.getDatasourceClass());
            iface.setCompliance(HOSTED_BY_COMPLIANCE);
            iface.setAccessProtocol("UNKNOWN");
            iface.setContentDescription("metadata");
            iface.setBaseUrl("");
            iface.setActive(false);
            iface.setRemovable(true);
            iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldForDate, date);
            iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldsForTotal, Integer.toString(size));
            iface.getExtraFields().put(namepsacePrefix + ":" + extraFieldForMdId, this.mdId);
            dsManager.addInterface(dsId, iface);
        }
        catch (DatasourceManagerServiceException e) {
            log.warn((Object)("Error setting hostedBy api of ds: " + dsId), (Throwable)e);
        }
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getCountersParam() {
        return this.countersParam;
    }

    public void setCountersParam(String countersParam) {
        this.countersParam = countersParam;
    }
}

