/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.index;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwitchIndexesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SwitchIndexesJobNode.class);
    private String xqueryForServiceIdParam;

    protected String execute(NodeToken token) throws Exception {
        Queue q = (Queue)token.getEnv().getTransientAttribute("searchService_ids");
        log.debug((Object)("Got the searchService_ids queue: " + q.toString()));
        if (q == null) {
            throw new MSROException("Transient param 'searchService_ids' with queue of string could not be found");
        }
        if (q.isEmpty()) {
            log.info((Object)"searchService_ids queue consumed, now ending cycle");
            return Arc.DEFAULT_ARC;
        }
        String id = (String)q.poll();
        log.debug((Object)("Polled id: " + id));
        log.debug((Object)("And now the queue is " + q));
        String xquery = "/RESOURCE_PROFILE[./HEADER/RESOURCE_IDENTIFIER/@value = '" + id + "']";
        token.getEnv().setAttribute(this.getXqueryForServiceIdParam(), xquery);
        log.debug((Object)("Asking to switch on profile identified by: " + xquery));
        token.getEnv().setTransientAttribute("searchService_ids", (Object)q);
        return "switch";
    }

    public String getXqueryForServiceIdParam() {
        return this.xqueryForServiceIdParam;
    }

    public void setXqueryForServiceIdParam(String xqueryForServiceIdParam) {
        this.xqueryForServiceIdParam = xqueryForServiceIdParam;
    }
}

