<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
				xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions"
				xmlns:dnet="eu.dnetlib.miscutils.functional.hash.Hashing"
				xmlns:clean="eu.dnetlib.msro.openaireplus.utils.CleaningXsltFunctions"
				version="1.0"
				exclude-result-prefixes="xsl dnet oaa fn  clean fn">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:template match="/">

		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:oaf="http://namespace.openaire.eu/oaf"
				xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:variable name="originalId" select="//*[local-name()='column' and ./@name='ISSN']"/>


					<xsl:variable name="id" select="concat($namespacePrefix,'::', $originalId)"/>

					<ROW table="doaj_temp_journal">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$id"/>
						</FIELD>
						<FIELD name="journalname">
							<xsl:value-of select=".//*[local-name()='column' and ./@name='Title']"/>
						</FIELD>
						<FIELD name="issn">
							<xsl:value-of select="//*[local-name()='column' and ./@name='ISSN']"/>
						</FIELD>
						<FIELD name="oa_source_id">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
					</ROW>
				</ROWS>
			</metadata>
		</record>

	</xsl:template>
</xsl:stylesheet>
