package eu.dnetlib.msro.openaireplus.workflows.nodes.repohi;

import javax.annotation.Resource;

import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.repohi.UpdateMetaWfStatusJobNode;

public class UpdateOpenaireMetaWfStatusJobNode extends UpdateMetaWfStatusJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected void updateDatasource(final String dsId, final String ifaceId) throws Exception {

		final String openaireDsId = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"/*[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']//FIELD/value[../key='OpenAireDataSourceId']/text()");

		if (openaireDsId.equals("openaire____::bootstrap")) {
			super.updateDatasource(dsId, ifaceId);
		} else {
			serviceLocator.getService(DatasourceManagerService.class).updateActivationStatus(openaireDsId, ifaceId, true);
		}
	}

}
