/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckHDFSCountJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CheckHDFSCountJobNode.class);
    private String numberToVerifyParamName;
    private String hdfsCounterParamName = "mainlog:storeHdfsRecords:count";

    public String execute(NodeToken token) throws MSROException {
        int hdfsCount = 0;
        int hbaseCount = 0;
        String numberToVerifyInEnvParam = "blackboard:param:" + this.numberToVerifyParamName;
        hbaseCount = this.getValueFromEnv(token, numberToVerifyInEnvParam);
        hdfsCount = this.getValueFromEnv(token, this.hdfsCounterParamName);
        if (hdfsCount != hbaseCount) {
            log.warn((Object)("Numbers are not the same. Number to verify (hbase count): " + hbaseCount + ". From hdfs: " + hdfsCount));
            log.warn((Object)(hdfsCount - hbaseCount + " records come without a 'metadata' field"));
            token.getEnv().setAttribute("noMetadataRecords", (Object)(hdfsCount - hbaseCount));
        }
        return Arc.DEFAULT_ARC;
    }

    private int getValueFromEnv(NodeToken token, String paramName) throws MSROException {
        String valueString = token.getEnv().getAttribute(paramName);
        int number = 0;
        try {
            number = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Env param name: " + paramName + " is " + valueString + " and cannot be parsed as integer"));
            throw new MSROException((Throwable)e);
        }
        return number;
    }

    public String getNumberToVerifyParamName() {
        return this.numberToVerifyParamName;
    }

    public void setNumberToVerifyParamName(String numberToVerifyParamName) {
        this.numberToVerifyParamName = numberToVerifyParamName;
    }

    public String getHdfsCounterParamName() {
        return this.hdfsCounterParamName;
    }

    public void setHdfsCounterParamName(String hdfsCounterParamName) {
        this.hdfsCounterParamName = hdfsCounterParamName;
    }
}

