<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('irb_hr______')"/>

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="//csvRecord/column[@name = 'FUNDER_NAME']/text() = 'HRZZ'">
				<fundingtree>
					<funder>
						<id>
							<xsl:value-of select="concat($namespacePrefix, '::HRZZ')"/>
						</id>
						<shortname>HRZZ</shortname>
						<name>Croatian Science Foundation (CSF)</name>
						<originalname>Hrvatska zaklada za znanost</originalname>
						<jurisdiction>HR</jurisdiction>
					</funder>
				</fundingtree>
			</xsl:when>
			<xsl:otherwise>
				<fundingtree/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


</xsl:stylesheet>
