package eu.dnetlib.msro.openaireplus.workflows.nodes.actions;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.rmi.ActionManagerService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import org.apache.commons.lang.StringUtils;

/**
 * Created by claudio on 14/04/16.
 */
public class PromoteActionsHDFSJobNode extends BlackboardJobNode {

	public static final String ALL_SETS = "ALL SETS";

	private String set;

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(ActionManagerService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		job.setAction("PROMOTE_FROM_HDFS");
		if (!StringUtils.isBlank(getSet()) && !getSet().equals(ALL_SETS)) {
			job.getParameters().put("set", getSet());
			token.getEnv().setAttribute("set", getSet());
		}
	}

	public String getSet() {
		return set;
	}

	public void setSet(final String set) {
		this.set = set;
	}

}
