package eu.dnetlib.pace.condition;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;

/**
 * Returns true if the year of the date field in the given documents are the same, 
 * false when any of the two is invalid or it's missing.
 * 
 * @author claudio
 */
public class YearMatch extends AbstractCondition {
	
	private int limit = 4;

	public YearMatch(List<String> fields) {
		super(fields);
	}

	@Override
	public boolean verify(Document a, Document b) {
		boolean res = true;
		for(String field : fields) {
			String valueA = getNumbers(getValue(a.values(field)));
			String valueB = getNumbers(getValue(b.values(field)));
			
			boolean lengthMatch = checkLength(valueA) && checkLength(valueB);
			boolean onemissing = valueA.isEmpty() || valueB.isEmpty();

			res = res && (lengthMatch && valueA.equals(valueB)) || onemissing;
		}
		
		return res;
	}
	
	protected boolean checkLength(String s) {
		return s.length() == limit;
	}
	
	private String getValue(List<Field> values) {
		return values != null && !values.isEmpty() ? StringUtils.left(values.get(0).getValue().toString(), limit) : null;
	}

}
