package eu.dnetlib.pace.config;

import java.util.List;
import java.util.Map;
import java.util.Set;

import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.CondDef;
import eu.dnetlib.pace.model.FieldDef;

/**
 * Interface for PACE configuration bean.
 * 
 * @author claudio
 */
public interface Config {

	public String identifierField();

	public List<FieldDef> fields();
	
	public List<CondDef> conditions();
	
	public List<ClusteringDef> clusterings();
	
	public List<FieldDef> strictFields();

	public FieldDef identifierFieldDef();
	
	public Map<String, Set<String>> blacklists();

}

