package eu.dnetlib.pace.distance;

import org.apache.commons.lang.StringUtils;

import com.wcohen.ss.AbstractStringDistance;

import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;

public class SubStringLevenstein extends SecondStringDistanceAlgo {
	
	protected int limit;
	
	public SubStringLevenstein(double w) {
		super(w, new com.wcohen.ss.Levenstein());
	}

	public SubStringLevenstein(double w, int limit) {
		super(w, new com.wcohen.ss.Levenstein());
		this.limit = limit;
	}

	protected SubStringLevenstein(double w, int limit, AbstractStringDistance ssalgo) {
		super(w, ssalgo);
		this.limit = limit;
	}
	
	@Override
	public double distance(Field a, Field b) {
		if (a.getType().equals(Type.String) && b.getType().equals(Type.String)) {
			return distance(StringUtils.left(a.getValue().toString(), limit), StringUtils.left(b.getValue().toString(), limit));
		}

		throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
	}
	

	@Override
	public double getWeight() {
		return super.weight;
	}

	@Override
	protected double normalize(double d) {
		return 1 / Math.pow(Math.abs(d) + 1, 0.1);
	}

}
