package eu.dnetlib.pace.model;

import java.util.List;

import eu.dnetlib.pace.clustering.Clustering;
import eu.dnetlib.pace.clustering.ClusteringFunction;

public class ClusteringDef {
	
	private Clustering clustering;
	
	private ClusteringFunction clusteringFunction;	
	
	private List<String> fields;
	
	public ClusteringDef(Clustering clustering, ClusteringFunction clusteringFunction, List<String> fields) {
		super();
		this.fields = fields;
		this.clustering = clustering;
		this.clusteringFunction = clusteringFunction;
	}

	public ClusteringFunction getClusteringFunction() {
		return clusteringFunction;
	}

	public List<String> getFields() {
		return fields;
	}
	
	@Override
	public String toString() {
		return clustering.toString() + fields.toString();
	}
	

}
