package eu.dnetlib.pace.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;

public class DocumentBuilder {

	public static MapDocument newInstance(String identifier, Map<String, List<Field>> fieldMap) {
		return new MapDocument(identifier, fieldMap);
	}
	
	public static MapDocument newInstance(String identifier, byte[] fieldMap) {
		return new MapDocument(identifier, fieldMap);
	}

	public static MapDocument newInstance(String id, GeneratedMessage metadata, List<FieldDef> fields) {
		return newInstance(id, new DocumentBuilder().generateFieldMap(metadata, fields));
	}

	private Map<String, List<Field>> generateFieldMap(GeneratedMessage metadata, List<FieldDef> fields) {
		Map<String, List<Field>> fieldMap = Maps.newHashMap();

		for (FieldDef fd : fields) {
			fieldMap.put(fd.getName(), processPath(fd.getName(), metadata, Arrays.asList(fd.getPath().split(FieldDef.PATH_SEPARATOR))));
		}

		return fieldMap;
	}

	public List<Field> processPath(String name, GeneratedMessage message, List<String> list) {

		final List<Field> response = Lists.newArrayList();

		if (list.isEmpty()) {
			throw new RuntimeException("ProtoBuf navigation path is empty");
		}

		FieldDescriptor desc = message.getDescriptorForType().findFieldByName(list.get(0));
		if (desc != null) {
			if (desc.isRepeated()) {
				int count = message.getRepeatedFieldCount(desc);
				for (int i = 0; i < count; i++) {
					Object field = message.getRepeatedField(desc, i);
					response.addAll(generateFields(name, field, list));
				}
			} else {
				Object field = message.getField(desc);
				response.addAll(generateFields(name, field, list));
			}
		} else {
			throw new RuntimeException("Invalid protobuf path (field not found): " + StringUtils.join(list, ">"));
		}

		return response;
	}

	private List<Field> generateFields(String name, Object field, List<String> list) {
		if (field instanceof GeneratedMessage) {
			if (list.size() > 1) {
				return processPath(name, (GeneratedMessage) field, list.subList(1, list.size()));
			} else {
				throw new RuntimeException("No primitive type found");
			}
		} else {
			if (list.size() == 1) {
				eu.dnetlib.pace.config.Type type = field instanceof Integer ? eu.dnetlib.pace.config.Type.Int : eu.dnetlib.pace.config.Type.String;

				return Lists.newArrayList(new Field(type, name, field));
			} else {
				throw new RuntimeException("Found a primitive type before the path end");
			}
		}
	}

}
