package eu.dnetlib.pace.model;

import java.util.List;

import com.google.common.base.Joiner;

import eu.dnetlib.pace.config.Type;

public class Field {

	private Type type = Type.String;
	private String name;
	private Object value = null;

	public Field() {
	}

	public Field(Type type, String name, Object value) {
		this.type = type;
		this.name = name;
		this.value = value;
	}

	public boolean isEmpty() {
		if (value == null) {
			return false;
		}

		switch (type) {
		case String:
			return value.toString().isEmpty();
		case List:
			List<?> list = (List<?>) value;
			return list.isEmpty() || ((Field) list.get(0)).isEmpty();
		default:
			return true;
		}
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@SuppressWarnings("unchecked")
	public String stringValue() {
		switch(getType()) {
		case Int:
			return String.valueOf(getValue());
		case List:
			return Joiner.on(" ").join((List<String>) getValue());
		case String:
			return (String) getValue();
		default:
			throw new IllegalArgumentException("Unknown type: " + getType().toString());
		}
	}		

}
