package eu.dnetlib.pace.model;

import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;

/**
 * The schema is composed by field definitions (FieldDef). Each field has a type, a name, and an associated distance
 * algorithm.
 */
public class FieldDef {

	public final static String PATH_SEPARATOR = "/";

	private String name;

	private DistanceAlgo algo;

	private boolean ignoreMissing;

	public FieldDef(String name, DistanceAlgo algo, boolean ignoreMissing) {
		this.name = name;
		this.algo = algo;
		this.ignoreMissing = ignoreMissing;
	}

	//def apply(s: String): Field[A]
	public Field apply(Type type, String s) {
		switch (type) {
		case Int:
			return new Field(type, name, Integer.parseInt(s));
		case String:
			return new Field(type, name, s);
		default:
			throw new IllegalArgumentException("Casting not implemented for type " + type);
		}
	}

	public String getName() {
		return name.split(PATH_SEPARATOR)[0];
	}

	public DistanceAlgo getAlgo() {
		return algo;
	}

	public boolean isIgnoreMissing() {
		return ignoreMissing;
	}

	public String getPath() {
		return name;
	}

	@Override
	public String toString() {
		return getPath() + " { algo='" + getAlgo().getClass().getSimpleName() + "' weigth='" + getAlgo().getWeight() + "' ignoreMissing='"
				+ isIgnoreMissing() + "' }";
	}
}
