package eu.dnetlib.pace.model;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

public class MapDocument implements Document {

	private String identifier;
	private Map<String, List<Field>> fieldMap;

	public MapDocument() {
		identifier = null;
		fieldMap = Maps.newHashMap();
	}

	public MapDocument(String identifier, Map<String, List<Field>> fieldMap) {
		this.setIdentifier(identifier);
		this.fieldMap = fieldMap;
	}
	
	public MapDocument(String identifier, byte[] data) {
		MapDocument doc = MapDocumentSerializer.decode(data);
		
		this.fieldMap = doc.fieldMap;
		this.identifier = doc.identifier;
	}

	@Override
	public Iterable<Field> fields() {
		return Lists.newArrayList(Iterables.concat(fieldMap.values()));
	}

	@Override
	public List<Field> values(String name) {
		return fieldMap.get(name);
	}
	
	@Override
	public Set<String> fieldNames() {
		return fieldMap.keySet();
	}

	@Override
	public String toString() {
		return MapDocumentSerializer.toString(this);
		//return String.format("Document(%s)", fieldMap.toString());
	}

	public byte[] toByteArray() {
		return MapDocumentSerializer.toByteArray(this);
	}

	@Override
	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public Map<String, List<Field>> getFieldMap() {
		return fieldMap;
	}

	public void setFieldMap(Map<String, List<Field>> fieldMap) {
		this.fieldMap = fieldMap;
	}

}
