package eu.dnetlib.pace.model;

import java.util.Comparator;

import eu.dnetlib.pace.clustering.NGramUtils;

public class MapDocumentComparator implements Comparator<Document> {

	private String comparatorField;

	public MapDocumentComparator(String comparatorField) {
		this.comparatorField = comparatorField;
	}

	@Override
	public int compare(Document d1, Document d2) {

		if (d1.values(comparatorField).isEmpty() || d2.values(comparatorField).isEmpty()) {
			return 0;
		}

		Object o1 = d1.values(comparatorField).get(0).getValue();
		Object o2 = d2.values(comparatorField).get(0).getValue();

		if (o1 == null || o2 == null) {
			return 0;
		}

		String to1 = NGramUtils.cleanupForOrdering(o1.toString());
		String to2 = NGramUtils.cleanupForOrdering(o2.toString());

		return to1.compareTo(to2);
	}

}
