package eu.dnetlib.pace.util;

import java.util.List;
import java.util.Set;

import com.google.gson.GsonBuilder;

import eu.dnetlib.data.proto.TypeProtos.Type;

public class DedupConfig {

	/**
	 * Entity type.
	 */
	private final Type entityType;

	/**
	 * Field name used to sort the values in the reducer phase.
	 */
	private final String orderField;

	/**
	 * Column Families involved in the relations redirection.
	 */
	private final List<String> rootBuilderFamilies;

	/**
	 * Set of datasource namespace prefixes that won't be deduplicated.
	 */
	private final Set<String> skipList;

	/**
	 * Subprefix used to build the root id, allows multiple dedup runs.
	 */
	private final String dedupRun;

	/**
	 * Similarity threshold.
	 */
	private final double threshold;

	public DedupConfig(Type entityType, String orderField, List<String> rootBuilderFamilies, String dedupRun, double threshold, Set<String> skipList) {
		super();
		this.entityType = entityType;
		this.orderField = orderField;
		this.rootBuilderFamilies = rootBuilderFamilies;
		this.dedupRun = dedupRun.contains("'") ? dedupRun.replaceAll("'", "") : dedupRun;
		this.threshold = threshold;
		this.skipList = skipList;
	}

	public Type getEntityType() {
		return entityType;
	}

	public String getEntityName() {
		return getEntityType().toString();
	}

	public byte[] getEntityNameBytes() {
		return getEntityType().toString().getBytes();
	}

	public String getEntityId() {
		return Integer.toString(getEntityType().getNumber());
	}

	public String getOrderField() {
		return orderField;
	}

	public List<String> getRootBuilderFamilies() {
		return rootBuilderFamilies;
	}

	public String getDedupRun() {
		return dedupRun;
	}

	public double getThreshold() {
		return threshold;
	}

	public Set<String> getSkipList() {
		return skipList;
	}

	@Override
	public String toString() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
