package eu.dnetlib.gwt.client.help;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.gwt.client.ckeditor.CKEditor;
import eu.dnetlib.gwt.shared.Help;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;

/**
 * Created by stefania on 3/9/16.
 */
public class AdminWidget implements IsWidget {

    private String token = "";

    private FlowPanel monitorHelpTextsPagePanel = new FlowPanel();
    private Label monitorHelpTextsTitleLabel = new Label();
    private Label monitorHelpTextsInfoLabel = new Label();

    private Alert successLabel = new Alert();
    private Alert errorLabel = new Alert();
    private Alert warningLabel = new Alert();

    private FlowPanel helpTextsPanel = new FlowPanel();

    private Form helpTextsForm = new Form();
    private ListBox helpTextsSelection = new ListBox();
    private TextArea textArea = new TextArea();
    private CKEditor editor;

    private Button submitChanges = new Button();
    private Button preview = new Button();

    private HelpPanel helpPanel = new HelpPanel("Help");
    private HelpPanel previewPanel = new HelpPanel("Preview");

    private DateTimeFormat dtf = DateTimeFormat.getFormat("yyyy/MM/dd");
    private HelpServiceAsync helpService = GWT.create(HelpService.class);

    public AdminWidget() {

        monitorHelpTextsPagePanel.addStyleName("content");

        monitorHelpTextsTitleLabel.setText("Monitor Help Texts");
        monitorHelpTextsTitleLabel.addStyleName("contentTitleLabel");

        monitorHelpTextsInfoLabel.setText("Monitor and change the help texts that appear on the sidebar of each page");
        monitorHelpTextsInfoLabel.addStyleName("contentInfoLabel");

        errorLabel.addStyleName("alertLabel");
        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        warningLabel.addStyleName("alertLabel");
        warningLabel.setType(AlertType.WARNING);
        warningLabel.setDismissable(false);
        warningLabel.setVisible(false);

        successLabel.addStyleName("alertLabel");
        successLabel.setType(AlertType.SUCCESS);
        successLabel.setDismissable(false);
        successLabel.setVisible(false);

        monitorHelpTextsPagePanel.add(monitorHelpTextsTitleLabel);
        monitorHelpTextsPagePanel.add(monitorHelpTextsInfoLabel);
        monitorHelpTextsPagePanel.add(successLabel);
        monitorHelpTextsPagePanel.add(errorLabel);
        monitorHelpTextsPagePanel.add(warningLabel);
        monitorHelpTextsPagePanel.add(helpTextsPanel);

        helpTextsForm.setType(FormType.HORIZONTAL);

        helpTextsSelection.addItem("None selected", "none");
        helpTextsSelection.addItem("User Registration", "register");
        helpTextsSelection.addItem("My Account", "myAccount");
        helpTextsSelection.addItem("Edit Account Info", "editAccountInfo");
        helpTextsSelection.addItem("Support", "support");
        helpTextsSelection.addItem("Statistics", "statistics");
        helpTextsSelection.addItem("Eligible Projects", "eligibleProjects");
        helpTextsSelection.addItem("Requests", "requests");
        helpTextsSelection.addItem("New Funding Request - Researcher", "newFundingRequest_researcher");
        helpTextsSelection.addItem("New Funding Request - Project", "newFundingRequest_project");
        helpTextsSelection.addItem("New Funding Request - Publication", "newFundingRequest_publication");
        helpTextsSelection.addItem("New Funding Request - Accounting", "newFundingRequest_accounting");
        helpTextsSelection.addItem("New Funding Request - Summary", "newFundingRequest_summary");
        helpTextsSelection.addItem("New Budget Request", "newBudgetRequest");
        helpTextsSelection.addItem("Existing Funding Request", "existingFundingRequests");
        helpTextsSelection.addItem("Existing Budget Request", "existingBudgetRequests");
        helpTextsSelection.addItem("Monitor", "monitor");
        helpTextsSelection.addItem("Monitor Funding Requests", "monitorFundingRequests");
        helpTextsSelection.addItem("Monitor Budgets", "monitorBudgets");
        helpTextsSelection.addItem("Monitor Users", "monitorUsers");
        helpTextsSelection.addItem("Monitor User Roles", "monitorUserRoles");
        helpTextsSelection.addItem("Monitor Help Texts", "monitorHelpTexts");
        helpTextsSelection.addItem("Accounting Monitor", "accountingMonitor");
        helpTextsSelection.addItem("Accounting Monitor Funding Requests", "accountingMonitorFundingRequests");
        helpTextsSelection.addItem("Accounting Monitor Budgets", "accountingMonitorBudgets");

        helpTextsSelection.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent changeEvent) {

                successLabel.setVisible(false);
                errorLabel.setVisible(false);
                warningLabel.setVisible(false);

                if(!helpTextsSelection.getSelectedValue().equals("none")) {
                    helpService.getHelpById(helpTextsSelection.getSelectedValue(), new AsyncCallback<Help>() {

                        @Override
                        public void onFailure(Throwable throwable) {

                            errorLabel.setText("System error retrieving help text");
                            errorLabel.setVisible(true);
                        }

                        @Override
                        public void onSuccess(Help help) {

                            if (help != null)
                                editor.setValue(help.getText());
                            else
                                editor.setValue("");

                        }
                    });
                } else {
                    editor.setValue("");
                }
            }
        });
        helpTextsForm.add(new MyFormGroup(false, "Select help item", helpTextsSelection));

        textArea.getElement().setId("editor");
        helpTextsForm.add(new MyFormGroup(false, "Edit help text", textArea));

        preview.setText("Preview");
        preview.setType(ButtonType.DEFAULT);
        preview.addStyleName("inlineBlock");
        preview.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent clickEvent) {

                if(editor!=null) {

                    HTML html = new HTML();
                    html.setHTML(editor.getValue());

                    previewPanel.clearContent();
                    previewPanel.addContent(html);
                }
            }
        });

        submitChanges.setText("Submit Changes");
        submitChanges.setType(ButtonType.PRIMARY);
        submitChanges.addStyleName("inlineBlock");
        submitChanges.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent clickEvent) {

                errorLabel.setVisible(false);
                warningLabel.setVisible(false);
                successLabel.setVisible(false);

                if(!helpTextsSelection.getSelectedValue().equals("none")) {

                    Help help = new Help();
                    help.setId(helpTextsSelection.getSelectedValue());
                    help.setText(editor.getValue());

                    helpService.saveHelp(help, new AsyncCallback<Help>() {

                        @Override
                        public void onFailure(Throwable throwable) {
                            errorLabel.setText("System error saving help text");
                            errorLabel.setVisible(true);
                        }

                        @Override
                        public void onSuccess(Help help) {
                            successLabel.setText("Help text saved successfully");
                            successLabel.setVisible(true);
                            //TODO fix this
//                            if(help.getId().equals("monitorHelpTexts"))
//                                HelpHelper.loadHelp(helpPanel, token.split("\\.")[0]);
                        }
                    });
                } else {
                    warningLabel.setText("No help item is selected");
                    warningLabel.setVisible(true);
                }
            }
        });

        helpTextsForm.add(new MyFormGroup(false, null, preview, submitChanges));

        helpTextsPanel.add(helpTextsForm);
    }

    public void clear() {

        errorLabel.setVisible(false);
        warningLabel.setVisible(false);
        successLabel.setVisible(false);

        helpPanel.clearContent();
        previewPanel.clearContent();

        if(editor!=null) {
            editor.destroy();
            editor = null;
        }

        textArea.setValue("");
        //TODO
//        helpTextsSelection.setSelectedValue("none");
    }

    public void reload() {

        //TODO fix this
//        MyWidgetHelper.showSidebar();
//
//        MyWidgetHelper.loadHelp(helpPanel, token.split("\\.")[0]);
//
//        RootPanel.get("sidebar").add(previewPanel.asWidget());
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void afterAdditionToRootPanel() {
        loadHelpTexts();
    }

    @Override
    public Widget asWidget() {
        return monitorHelpTextsPagePanel;
    }

    private void loadHelpTexts() {

        if(editor==null) {
            editor = new CKEditor(textArea.getElement().getId());
            editor.setUIColor("#dfd9d2");
        }
    }
}
