package eu.dnetlib.gwt.client.help;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;
import eu.dnetlib.gwt.client.MyFormGroup;
import eu.dnetlib.gwt.client.ckeditor.CKEditor;
import eu.dnetlib.gwt.shared.Help;
import org.gwtbootstrap3.client.ui.*;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.FormType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by stefania on 3/9/16.
 */
public class AdminWidget implements IsWidget {

    private String token = "";
    private String uiColor = "#f5f6f8";

    private FlowPanel monitorHelpTextsPagePanel = new FlowPanel();
    private Label monitorHelpTextsTitleLabel = new Label();
    private Label monitorHelpTextsInfoLabel = new Label();

    private Alert successLabel = new Alert();
    private Alert errorLabel = new Alert();
    private Alert warningLabel = new Alert();

    private FlowPanel helpTextsPanel = new FlowPanel();

    private Form helpTextsForm = new Form();
    private ListBox helpTextsSelection = new ListBox();
    private TextArea textArea = new TextArea();
    private CKEditor editor;

    private Button submitChanges = new Button();
    private Button preview = new Button();

    private FlowPanel previewPanel;

    private Map<String, Help> helpMap = new HashMap<String, Help>();

    private DateTimeFormat dtf = DateTimeFormat.getFormat("yyyy/MM/dd");
    private HelpServiceAsync helpService = GWT.create(HelpService.class);

    private HelpTextUpdatedListener helpTextUpdatedListener;

    public AdminWidget(final FlowPanel previewPanel, boolean addButtons) {

        this.previewPanel = previewPanel;

        errorLabel.setType(AlertType.DANGER);
        errorLabel.setDismissable(false);
        errorLabel.setVisible(false);

        warningLabel.setType(AlertType.WARNING);
        warningLabel.setDismissable(false);
        warningLabel.setVisible(false);

        successLabel.setType(AlertType.SUCCESS);
        successLabel.setDismissable(false);
        successLabel.setVisible(false);

        monitorHelpTextsPagePanel.add(successLabel);
        monitorHelpTextsPagePanel.add(errorLabel);
        monitorHelpTextsPagePanel.add(warningLabel);
        monitorHelpTextsPagePanel.add(helpTextsPanel);

        helpTextsSelection.addItem("None selected", "none");

        helpTextsSelection.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent changeEvent) {

                successLabel.setVisible(false);
                errorLabel.setVisible(false);
                warningLabel.setVisible(false);

                if(!helpTextsSelection.getSelectedValue().equals("none")) {
                    helpService.getHelpById(helpTextsSelection.getSelectedValue(), new AsyncCallback<Help>() {

                        @Override
                        public void onFailure(Throwable throwable) {

                            errorLabel.setText("System error retrieving help text");
                            errorLabel.setVisible(true);
                        }

                        @Override
                        public void onSuccess(Help help) {

                            if (help != null)
                                editor.setValue(help.getText());
                            else
                                editor.setValue("");

                        }
                    });
                } else {
                    editor.setValue("");
                }
            }
        });
        helpTextsForm.add(new MyFormGroup(false, "Select help item", helpTextsSelection));

        textArea.getElement().setId("editor");
        helpTextsForm.add(new MyFormGroup(false, "Edit help text", textArea));

        if(addButtons) {

            preview.setText("Preview");
            preview.setType(ButtonType.DEFAULT);
            preview.addStyleName("inlineBlock");
            preview.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent clickEvent) {
                    previewHelpText();
                }
            });

            submitChanges.setText("Submit Changes");
            submitChanges.setType(ButtonType.PRIMARY);
            submitChanges.addStyleName("inlineBlock");
            submitChanges.addClickHandler(new ClickHandler() {

                @Override
                public void onClick(ClickEvent clickEvent) {
                    saveHelpText();
                }
            });

            helpTextsForm.add(new MyFormGroup(false, null, preview, submitChanges));
        }

        helpTextsPanel.add(helpTextsForm);
    }

    public void previewHelpText() {

        if(editor!=null) {

            HTML html = new HTML();
            html.setHTML(editor.getValue());

            previewPanel.clear();
            previewPanel.add(html);
        }
    }

    public void saveHelpText() {

        errorLabel.setVisible(false);
        warningLabel.setVisible(false);
        successLabel.setVisible(false);

        if(!helpTextsSelection.getSelectedValue().equals("none")) {

            Help help = new Help();
            help.setId(helpTextsSelection.getSelectedValue());
            help.setName(helpMap.get(helpTextsSelection.getSelectedValue()).getName());
            help.setText(editor.getValue());

            helpService.saveHelp(help, new AsyncCallback<Help>() {

                @Override
                public void onFailure(Throwable throwable) {
                    errorLabel.setText("System error saving help text");
                    errorLabel.setVisible(true);
                }

                @Override
                public void onSuccess(Help help) {
                    successLabel.setText("Help text saved successfully");
                    successLabel.setVisible(true);

                    if(helpTextUpdatedListener!=null)
                        helpTextUpdatedListener.helpTextUpdated(help);
                }
            });
        } else {
            warningLabel.setText("No help item is selected");
            warningLabel.setVisible(true);
        }
    }

    public interface HelpTextUpdatedListener {
        void helpTextUpdated(Help updatedHelp);
    }

    public void setHelpTextUpdatedListener(HelpTextUpdatedListener helpTextUpdatedListener) {
        this.helpTextUpdatedListener = helpTextUpdatedListener;
    }

    public void clear() {

        errorLabel.setVisible(false);
        warningLabel.setVisible(false);
        successLabel.setVisible(false);

        previewPanel.clear();

        if(editor!=null) {
            editor.destroy();
            editor = null;
        }

        textArea.setValue("");
        //TODO
//        helpTextsSelection.setSelectedValue("none");
    }

    public void reload() {
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void afterAdditionToRootPanel() {
        loadHelpTexts();
    }

    @Override
    public Widget asWidget() {
        return monitorHelpTextsPagePanel;
    }

    public void setEditorUIColor(String color) {
        this.uiColor = color;
    }

    public void addStyleName(String styleName) {
        monitorHelpTextsPagePanel.addStyleName(styleName);
    }

    public void setFormType(FormType formType) {
        helpTextsForm.setType(formType);
    }

    public void setHelpTexts(List<Help> helpTexts) {

        helpMap.clear();
        helpTextsSelection.clear();

        helpTextsSelection.addItem("None selected", "none");
        for(Help help : helpTexts) {
            helpTextsSelection.addItem(help.getName(), help.getId());
            helpMap.put(help.getId(), help);
        }
    }

    private void loadHelpTexts() {

        if(editor==null) {
            editor = new CKEditor(textArea.getElement().getId(), uiColor);
        }
    }
}
