package eu.dnetlib.gwt.client.help;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;

/**
 * Created by stefania on 3/9/16.
 */
public class HelpPanel implements IsWidget {

    private FlowPanel helpPanel = new FlowPanel();

    private HTML helpLabel = new HTML();

    public HelpPanel(String title) {

        helpLabel.setHTML("<h3 class=\"uk-panel-title\">" + title + "</h3>");

        helpPanel.add(helpLabel);
    }

    @Override
    public Widget asWidget() {
        return helpPanel;
    }

    public void clearContent() {
        helpPanel.clear();
        helpPanel.add(helpLabel);
    }

    public void addContent(IsWidget widget) {
        helpPanel.add(widget.asWidget());
    }

    public void addStyleName(String styleName) {
        helpPanel.addStyleName(styleName);
    }
}
