package eu.dnetlib.gwt.client.ckeditor;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.user.client.Window;

/**
 * Created by stefania on 4/17/15.
 */
public class CKEditor {

    protected CKEditorJSO editor;

    public CKEditor(final String id, final String color) {

        ScriptInjector.fromUrl("//cdn.ckeditor.com/4.5.7/full/ckeditor.js").setCallback(
                new Callback<Void, Exception>() {
                    public void onFailure(Exception reason) {
                    }
                    public void onSuccess(Void result) {
                        editor = initCKEditor(id);
                        setUIColor(color);
                    }
                }).setWindow(ScriptInjector.TOP_WINDOW).inject();
    }

    public void setValue(String value) {
        editor.setData(value);
    }

    public String getValue() {
        return editor.getData();
    }

    public void setUIColor(String value) {
        editor.setUiColor(value);
    }

    public void destroy() {
        editor.destroy();
    }

    private native CKEditorJSO initCKEditor(String id) /*-{
        return $wnd.CKEDITOR.replace( id );
    }-*/;
}