/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class CascadingUtils {
    private static final String[] PROPERTIES_TO_COPY = new String[]{"mapred.reduce.tasks"};

    private CascadingUtils() {
    }

    public static void addLibJars(Properties properties) throws IOException {
        ArrayList<String> jars = new ArrayList<String>();
        for (String fileName : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file = new File(fileName);
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !file.getParentFile().getName().toLowerCase(Locale.ENGLISH).equals("lib") || !fileName.toLowerCase(Locale.ENGLISH).contains("distcache")) continue;
            jars.add("file://" + file.getAbsolutePath());
        }
        String tmpjars = StringUtils.join(jars, (String)",");
        if (StringUtils.isNotBlank((String)tmpjars)) {
            properties.setProperty("tmpjars", tmpjars);
        }
    }

    public static void copyBasicProperties(Properties properties) {
        for (String key : PROPERTIES_TO_COPY) {
            String value = System.getProperty(key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
    }
}

