/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import eu.dnetlib.iis.ingest.pmc.citations.schemas.PmidMapping;
import eu.dnetlib.iis.ingest.pmc.metadata.schemas.ExtractedDocumentMetadata;
import java.io.IOException;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class PmidToOaidMapper
extends Mapper<AvroKey<ExtractedDocumentMetadata>, NullWritable, AvroKey<String>, AvroValue<PmidMapping>> {
    protected void map(AvroKey<ExtractedDocumentMetadata> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        ExtractedDocumentMetadata docMeta = (ExtractedDocumentMetadata)key.datum();
        if (docMeta.getPmid() != null && docMeta.getPmid().length() > 0) {
            PmidMapping result = PmidMapping.newBuilder().setPmId(docMeta.getPmid()).setEntityType(docMeta.getEntityType()).setOaId(docMeta.getId()).build();
            context.write((Object)new AvroKey((Object)docMeta.getPmid().toString()), (Object)new AvroValue((Object)result));
        }
    }
}

