/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import cascading.avro.AvroScheme;
import cascading.avro.PackedAvroScheme;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.hadoop.HadoopFlowConnector;
import cascading.pipe.Pipe;
import cascading.property.AppProps;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import eu.dnetlib.iis.common.schemas.IdentifierMapping;
import eu.dnetlib.iis.ingest.pmc.citations.CascadingUtils;
import eu.dnetlib.iis.ingest.pmc.citations.ResolvedCitationsSubAssembly;
import eu.dnetlib.iis.ingest.pmc.citations.schemas.Citation;
import eu.dnetlib.iis.ingest.pmc.metadata.schemas.ExtractedDocumentMetadata;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ResolvedCitationsImporter {
    public static void main(String[] args) throws IOException {
        String inPath = args[0];
        String dedupPath = args[1];
        String pmidToOaidPath = args[2];
        String doiToOaidPath = args[3];
        String outPath = args[4];
        Properties properties = new Properties();
        AppProps.setApplicationJarClass((Map)properties, ResolvedCitationsImporter.class);
        CascadingUtils.addLibJars(properties);
        CascadingUtils.copyBasicProperties(properties);
        properties.setProperty("mapred.task.timeout", "1800000");
        HadoopFlowConnector flowConnector = new HadoopFlowConnector((Map)properties);
        Hfs docTap = new Hfs((Scheme)new PackedAvroScheme(ExtractedDocumentMetadata.getClassSchema()), inPath);
        Hfs dedupTap = new Hfs((Scheme)new AvroScheme(IdentifierMapping.getClassSchema()), dedupPath);
        Hfs pmidToOaidTap = new Hfs((Scheme)new AvroScheme(IdentifierMapping.getClassSchema()), pmidToOaidPath);
        Hfs doiToOaidTap = new Hfs((Scheme)new AvroScheme(IdentifierMapping.getClassSchema()), doiToOaidPath);
        Pipe docPipe = new Pipe("doc");
        Pipe dedupMapPipe = new Pipe("dedup");
        Pipe pmidToOaidPipe = new Pipe("pmid_to_oaid");
        Pipe doiToOaidPipe = new Pipe("doi_to_oaid");
        Hfs outTap = new Hfs((Scheme)new PackedAvroScheme(Citation.getClassSchema()), outPath);
        ResolvedCitationsSubAssembly main = new ResolvedCitationsSubAssembly(docPipe, dedupMapPipe, pmidToOaidPipe, doiToOaidPipe);
        FlowDef flowDef = FlowDef.flowDef().addSource(docPipe, (Tap)docTap).addSource(dedupMapPipe, (Tap)dedupTap).addSource(pmidToOaidPipe, (Tap)pmidToOaidTap).addSource(doiToOaidPipe, (Tap)doiToOaidTap).addTailSink(main.getTails()[0], (Tap)outTap);
        Flow flow = flowConnector.connect(flowDef);
        flow.complete();
    }
}

