package eu.dnetlib.iis.ingest.pmc.citations;

import static eu.dnetlib.iis.ingest.pmc.citations.Constants.DST_FIELD;
import static eu.dnetlib.iis.ingest.pmc.citations.Constants.DST_IDS_FIELD;
import static eu.dnetlib.iis.ingest.pmc.citations.Constants.RAW_TEXT_FIELD;
import static eu.dnetlib.iis.ingest.pmc.citations.Constants.SRC_FIELD;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Tuple;
import eu.dnetlib.iis.ingest.pmc.citations.schemas.Citation;

/**
 * Converts tuple into a Citation.
 *
 * @see eu.dnetlib.iis.ingest.pmc.citations.schemas.Citation
 *
 * @author Mateusz Fedoryszak (m.fedoryszak@icm.edu.pl)
 * @author mhorst
 */
public class CitationReshaperFuncion extends BaseOperation implements Function {
    @Override
    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        Citation cit = new Citation();
        cit.setSourceDocumentId(functionCall.getArguments().getString(SRC_FIELD));

        String rawText = functionCall.getArguments().getString(RAW_TEXT_FIELD);
        if (StringUtils.isNotEmpty(rawText)) {
            cit.setRawText(rawText);
        }

        String dstId = functionCall.getArguments().getString(DST_FIELD);
        if (StringUtils.isNotEmpty(dstId)) {
            cit.setDestinationDocumentId(dstId);
        }

        Map<CharSequence, CharSequence> dstIds = new HashMap<CharSequence, CharSequence>();
        try {
        	String dstIdsJson = functionCall.getArguments().getString(DST_IDS_FIELD);
        	if (dstIdsJson!=null) {
        		JSONObject ids = new JSONObject(dstIdsJson);
                Iterator it = ids.keys();
                while (it.hasNext()) {
                    String type = (String)it.next();
                    dstIds.put(type, ids.getString(type));
                }	
        	}
        } catch (JSONException e) {
            e.printStackTrace();
        }
        cit.setExternalDestinationDocumentIds(dstIds);

        functionCall.getOutputCollector().add(new Tuple(cit));
    }
}
