package eu.dnetlib.iis.ingest.pmc.citations;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import org.apache.commons.lang.StringUtils;

/**
 * Replaces contents of specified field with a different one if replacer is not empty.
 *
 * @author Mateusz Fedoryszak (m.fedoryszak@icm.edu.pl)
 */
public class ReplacerFunction extends BaseOperation implements Function {
    private final Fields additional;
    private final Fields replacer;
    private final Fields original;

    public ReplacerFunction(Fields original, Fields replacer, Fields additional) {
        super(2 + additional.size(), new Fields().append(original).append(additional));
        this.original = original;
        this.replacer = replacer;
        this.additional = additional;
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        String originalVal  = functionCall.getArguments().getString(original);
        String replacerVal  = functionCall.getArguments().getString(replacer);
        String value = StringUtils.isBlank(replacerVal) ? originalVal : replacerVal;

        Tuple result = new Tuple();
        result.addString(value);

        result.addAll(functionCall.getArguments().selectTupleCopy(additional));
        functionCall.getOutputCollector().add(result);
    }
}
