/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import eu.dnetlib.iis.metadataextraction.schemas.Range;
import eu.dnetlib.iis.metadataextraction.schemas.ReferenceBasicMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.edu.icm.ceon.scala_commons.xml.XPathEvaluator;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class ResolvedCitation {
    private final String sourceOaid;
    private final int position;
    private final String rawText;
    private final Map<String, String> targetIds;
    private static final String PMID_KEY = "pmid";
    private static final String DOI_KEY = "doi";

    public ResolvedCitation(String sourceOaid, int position, String rawText, Map<String, String> targetIds) {
        this.sourceOaid = sourceOaid;
        this.position = position;
        this.rawText = rawText;
        this.targetIds = targetIds;
    }

    public String getSourceOaid() {
        return this.sourceOaid;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRawText() {
        return this.rawText;
    }

    public String getTargetPmid() {
        return this.targetIds.get(PMID_KEY);
    }

    public String getTargetDoi() {
        return this.targetIds.get(DOI_KEY);
    }

    public String getTargetIdsJson() {
        return new JSONObject(this.targetIds).toString();
    }

    public static List<ResolvedCitation> extractFromNlm(String oaSourceId, String text) {
        XPathEvaluator evaluator = XPathEvaluator.fromInputStream((InputStream)IOUtils.toInputStream((String)text));
        ArrayList<ResolvedCitation> result = new ArrayList<ResolvedCitation>();
        int position = 1;
        for (Node ref : JavaConversions.asJavaCollection((Iterable)evaluator.asNodes("/article/back/ref-list/ref"))) {
            XPathEvaluator refEvaluator = new XPathEvaluator((Object)ref);
            HashMap<String, String> targetIds = new HashMap<String, String>();
            for (Node citId : JavaConversions.asJavaCollection((Iterable)refEvaluator.asNodes(".//pub-id"))) {
                String idType = citId.getAttributes().getNamedItem("pub-id-type").getTextContent();
                String idValue = citId.getTextContent();
                targetIds.put(idType, idValue);
            }
            result.add(new ResolvedCitation(oaSourceId, position, ResolvedCitation.generateReferenceRawText(ref), targetIds));
            ++position;
        }
        return result;
    }

    public static String generateReferenceRawText(Node ref) {
        if (ResolvedCitation.containsTextChild(ref).booleanValue()) {
            return ref.getTextContent();
        }
        return ResolvedCitation.generateReferenceRawText(ResolvedCitation.buildReference(ref));
    }

    public static String generateReferenceRawText(ReferenceBasicMetadata refMeta) {
        String authors = refMeta.getAuthors() != null ? StringUtils.join((Collection)refMeta.getAuthors(), (String)", ") : "";
        String title = refMeta.getTitle() != null ? refMeta.getTitle().toString() : null;
        String source = refMeta.getSource() != null ? refMeta.getSource().toString() : null;
        String year = refMeta.getYear() != null ? refMeta.getYear().toString() : null;
        String volume = refMeta.getVolume() != null ? refMeta.getVolume().toString() : null;
        String issue = refMeta.getIssue() != null ? refMeta.getIssue().toString() : null;
        String fpage = refMeta.getPages() != null && refMeta.getPages().getStart() != null ? refMeta.getPages().getStart().toString() : null;
        String lpage = refMeta.getPages() != null && refMeta.getPages().getEnd() != null ? refMeta.getPages().getEnd().toString() : null;
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)authors)) {
            builder.append(authors);
            builder.append(". ");
        }
        if (StringUtils.isNotBlank((String)title)) {
            builder.append(title);
            builder.append(". ");
        }
        if (StringUtils.isNotBlank((String)source)) {
            builder.append(source);
            builder.append(". ");
        }
        if (StringUtils.isNotBlank((String)year)) {
            builder.append(year);
        }
        if (StringUtils.isNotBlank((String)volume)) {
            builder.append("; ");
            builder.append(volume);
        }
        if (StringUtils.isNotBlank((String)issue)) {
            builder.append(" (");
            builder.append(issue);
            builder.append(")");
        }
        if (StringUtils.isNotBlank((String)fpage)) {
            builder.append(": ");
            builder.append(fpage);
        }
        if (StringUtils.isNotBlank((String)lpage)) {
            builder.append("-");
            builder.append(lpage);
        }
        return builder.toString();
    }

    public static ReferenceBasicMetadata buildReference(Node ref) {
        ReferenceBasicMetadata.Builder refBuilder = ReferenceBasicMetadata.newBuilder();
        XPathEvaluator refEvaluator = new XPathEvaluator((Object)ref);
        ArrayList<String> authorsList = new ArrayList<String>();
        for (Node name : JavaConversions.asJavaCollection((Iterable)refEvaluator.asNodes(".//name"))) {
            XPathEvaluator nameEvaluator = new XPathEvaluator((Object)name);
            String surname = nameEvaluator.apply(".//surname");
            String givenNames = nameEvaluator.apply(".//given-names");
            authorsList.add(surname + ", " + givenNames);
        }
        if (authorsList.size() > 0) {
            refBuilder.setAuthors(authorsList);
        }
        refBuilder.setTitle((CharSequence)refEvaluator.apply(".//article-title"));
        refBuilder.setSource((CharSequence)refEvaluator.apply(".//source"));
        refBuilder.setYear((CharSequence)refEvaluator.apply(".//year"));
        refBuilder.setVolume((CharSequence)refEvaluator.apply(".//volume"));
        refBuilder.setIssue((CharSequence)refEvaluator.apply(".//issue"));
        String fpage = refEvaluator.apply(".//fpage");
        String lpage = refEvaluator.apply(".//lpage");
        if (fpage != null || lpage != null) {
            Range.Builder rangeBuilder = Range.newBuilder();
            rangeBuilder.setStart((CharSequence)fpage);
            rangeBuilder.setEnd((CharSequence)lpage);
            refBuilder.setPages(rangeBuilder.build());
        }
        return refBuilder.build();
    }

    public static Boolean containsTextChild(Node ref) {
        String xpath;
        XPathEvaluator refEval = new XPathEvaluator((Object)ref);
        Node cit = null;
        String[] arr$ = new String[]{"./citation", "./element-citation", "./mixed-citation"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (cit = refEval.asNode(xpath = arr$[i$])) == null; ++i$) {
        }
        if (cit == null) {
            return false;
        }
        NodeList children = cit.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3 || children.item(i).getNodeValue().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

