/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.plaintext;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import org.jdom.Element;
import org.jdom.Text;

public final class NlmToDocumentTextConverter {
    private NlmToDocumentTextConverter() {
    }

    public static String getDocumentText(Element source) {
        return Joiner.on((String)"\n").skipNulls().join((Object)NlmToDocumentTextConverter.getMetadataText(source), (Object)NlmToDocumentTextConverter.getBodyText(source), new Object[]{NlmToDocumentTextConverter.getReferencesText(source)});
    }

    public static String getMetadataText(Element source) {
        return source.getChild("front") == null ? null : NlmToDocumentTextConverter.getText(source.getChild("front"), Lists.newArrayList((Object[])new String[]{"journal-meta", "article-meta", "abstract"}));
    }

    public static String getBodyText(Element source) {
        return source.getChild("body") == null ? null : NlmToDocumentTextConverter.getText(source.getChild("body"), Lists.newArrayList((Object[])new String[]{"sec", "p", "title"}));
    }

    public static String getReferencesText(Element source) {
        return source.getChild("back") == null ? null : "References\n" + NlmToDocumentTextConverter.getText(source.getChild("back"), Lists.newArrayList((Object[])new String[]{"ref"}));
    }

    private static String getText(Element from, List<String> insertNewlineBefore) {
        StringBuilder sb = new StringBuilder();
        for (Object child : from.getContent()) {
            String cont;
            if (child instanceof Element) {
                String childAsText = NlmToDocumentTextConverter.getText((Element)child, insertNewlineBefore).trim();
                if (childAsText.isEmpty()) continue;
                if (insertNewlineBefore.contains(((Element)child).getName())) {
                    sb.append("\n");
                } else {
                    sb.append(" ");
                }
                sb.append(childAsText);
                continue;
            }
            if (!(child instanceof Text) || (cont = ((Text)child).getText().trim()).isEmpty()) continue;
            sb.append(" ");
            sb.append(cont);
        }
        return sb.toString().trim();
    }
}

