package eu.dnetlib.iis.ingest.pmc.citations;

import java.io.IOException;

import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

import eu.dnetlib.iis.ingest.pmc.citations.schemas.PmidMapping;
import eu.dnetlib.iis.ingest.pmc.metadata.schemas.ExtractedDocumentMetadata;

/**
 * Mapper class creating pmid to oaid mappings from PMC XML files.
 * @author mhorst
 */

public class PmidToOaidMapper 
	extends Mapper<AvroKey<ExtractedDocumentMetadata>, NullWritable, AvroKey<String>, AvroValue<PmidMapping>> {
	
    @Override
	protected void map(AvroKey<ExtractedDocumentMetadata> key, NullWritable value, Context context) 
            throws IOException, InterruptedException {
    	ExtractedDocumentMetadata docMeta = key.datum();
    	if (docMeta.getPmid()!=null && docMeta.getPmid().length()>0) {
			PmidMapping result = PmidMapping.newBuilder()
			.setPmId(docMeta.getPmid())
			.setEntityType(docMeta.getEntityType())
			.setOaId(docMeta.getId()).build();
        	context.write(
        			new AvroKey<String>(docMeta.getPmid().toString()),
        			new AvroValue<PmidMapping>(result));   
    	}
	}
}
