/*
 * Copyright (c) 2014-2014 ICM UW
 */

package eu.dnetlib.iis.ingest.pmc.metadata

import javax.xml.xpath.XPathExpressionException
import eu.dnetlib.iis.metadataextraction.schemas.ExtractedDocumentMetadata
import pl.edu.icm.ceon.scala_commons.xml.XPathEvaluator
import scala.util.Try
import scala.collection.JavaConversions._
import eu.dnetlib.iis.metadataextraction.schemas.ReferenceMetadata
import eu.dnetlib.iis.ingest.pmc.citations.ResolvedCitation
import scala.collection.mutable.ListBuffer


/**
 * @author Michal Oniszczuk (m.oniszczuk@icm.edu.pl)
 *         Created: 15.07.2014 12:55
 */
object NlmToMetadataExtractor {

  def headOrNull[T >: Null](xs: Seq[T]): T = xs
      .headOption
      .getOrElse(null)

  @throws(classOf[XPathExpressionException])
  def nlmToMetadata(nlm: String, basicMeta: ExtractedDocumentMetadata.Builder): ExtractedDocumentMetadata = {
    val eval = XPathEvaluator.fromString(nlm)

    // TODO many titles: which to choose
    // TODO title languages: which title to choose (english as a default?)
//    basicMeta.setTitle(headOrNull(eval.asStrings( """/article/front/article-meta/title-group/article-title""")))
    // TODO many abstracts
    // TODO abstract languages: which title to choose (english as a default?)
//    basicMeta.setAbstract$(headOrNull(eval.asStrings( """/article/front/article-meta/abstract""")))
    // TODO which language?
    // basicMeta setLanguage
//    basicMeta.setKeywords(eval.asStrings( """/article/front/article-meta/kwd-group/kwd""").toList)
    // TODO filter out main id
//    basicMeta setExternalIdentifiers eval.asStrings( """/article/front/article-meta/article-id""")
//    basicMeta.setJournal(eval( """/article/front/journal-meta/journal-title-group/journal-title"""))
//    Try(basicMeta.setYear(eval( """/article/front/article-meta/pub-date/year""").toInt))

    // handling references
    val references: ListBuffer[ReferenceMetadata] = ListBuffer()
    var position = 1

    for (ref <- eval.asNodes("""/article/back/ref-list/ref""")) {
      val refMetaBuilder = ReferenceMetadata.newBuilder()
      refMetaBuilder.setPosition(position)
      val refBasicMeta = ResolvedCitation.buildReference(ref)
//      // TODO uwaga: referencja moze byc zdefiniowana tylko jako text, wtedy trzeba to stokenizować
//      // bo w kodzie mateusza chodzilo tylko o zbudowanie stringa
      refMetaBuilder.setBasicMetadata(refBasicMeta)
      if (ResolvedCitation.containsTextChild(ref)) {
        refMetaBuilder.setText(ref.getTextContent())
      } else {
        refMetaBuilder.setText(ResolvedCitation.generateReferenceRawText(refBasicMeta))
      }
      references.add(refMetaBuilder.build())
      position += 1
    }
    
    if (references.size>0) {
      basicMeta.setReferences(references)  
    }
    
    basicMeta.build()
  }

}

