package eu.dnetlib.iis.ingest.pmc.citations;

import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

/**
 * @author Mateusz Fedoryszak (m.fedoryszak@icm.edu.pl)
 */
public class CascadingUtils {
    private CascadingUtils() {}

    /**
     * Configures Cascading properties so that all the jars from the specified libjarsDir are distributed among
     * worker nodes.
     */
    public static void addLibJars(Properties properties) throws IOException {
        List<String> jars = new ArrayList<String>();
        for (String fileName : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File file = new File(fileName);
            if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")
                    && file.getParentFile().getName().toLowerCase(Locale.ENGLISH).equals("lib")
                    && fileName.toLowerCase(Locale.ENGLISH).contains("distcache")) {
                jars.add("file://" + file.getAbsolutePath());
            }
        }
        String tmpjars = StringUtils.join(jars, ",");
        if (StringUtils.isNotBlank(tmpjars)) {
            properties.setProperty("tmpjars", tmpjars);
        }
    }

    /**
     * Defines properties to be copied by @link{#copyBasicProperties(Properties)}.
     */
    private static final String[] PROPERTIES_TO_COPY = new String[] {"mapred.reduce.tasks"};

    /**
     * Copies some basic application properties into job properties.
     */
    public static void copyBasicProperties(Properties properties) {
        for (String key : PROPERTIES_TO_COPY) {
            String value = System.getProperty(key);
            if (value != null) {
                properties.setProperty(key, value);
            }
        }
    }
}
