/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import eu.dnetlib.iis.ingest.pmc.metadata.schemas.ExtractedDocumentMetadata;
import eu.dnetlib.iis.ingest.pmc.metadata.schemas.ReferenceMetadata;
import org.apache.avro.util.Utf8;
import org.codehaus.jettison.json.JSONObject;

public class CitationExtractorFunction
extends BaseOperation
implements Function {
    private static final Fields fields = new Fields(new Comparable[]{"sourceDocumentId", "position", "rawText", "destinationDocumentId", "destinationDocumentIds", "destinationDoi", "destinationPmid"});
    private static final Utf8 PMID_KEY_UTF8 = new Utf8("pmid");
    private static final Utf8 DOI_KEY_UTF8 = new Utf8("doi");

    public CitationExtractorFunction() {
        super(1, fields);
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        try {
            Tuple docTuple = functionCall.getArguments().getTuple();
            ExtractedDocumentMetadata meta = (ExtractedDocumentMetadata)docTuple.iterator().next();
            if (meta.getReferences() != null) {
                for (ReferenceMetadata refMeta : meta.getReferences()) {
                    Tuple result = new Tuple();
                    result.addString(meta.getId().toString());
                    result.addInteger(refMeta.getPosition().intValue());
                    result.addString(refMeta.getText() != null ? refMeta.getText().toString() : null);
                    result.addString(null);
                    if (refMeta.getBasicMetadata() != null && !refMeta.getBasicMetadata().getExternalIds().isEmpty()) {
                        result.addString(new JSONObject(refMeta.getBasicMetadata().getExternalIds()).toString());
                        CharSequence doiCharSeq = (CharSequence)refMeta.getBasicMetadata().getExternalIds().get(DOI_KEY_UTF8);
                        result.addString(doiCharSeq != null ? doiCharSeq.toString() : null);
                        CharSequence pmidCharSeq = (CharSequence)refMeta.getBasicMetadata().getExternalIds().get(PMID_KEY_UTF8);
                        result.addString(pmidCharSeq != null ? pmidCharSeq.toString() : null);
                    } else {
                        result.addString(null);
                        result.addString(null);
                        result.addString(null);
                    }
                    functionCall.getOutputCollector().add(result);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

