/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.ingest.pmc.citations;

import eu.dnetlib.iis.common.schemas.IdentifierMapping;
import eu.dnetlib.iis.ingest.pmc.citations.schemas.PmidMapping;
import java.io.IOException;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;

public class PmidToOaidReducer
extends Reducer<AvroKey<String>, AvroValue<PmidMapping>, AvroKey<IdentifierMapping>, NullWritable> {
    public static final String ENTITY_TYPE_RESEARCH_ARTICLE = "research-article";

    public void reduce(AvroKey<String> key, Iterable<AvroValue<PmidMapping>> values, Reducer.Context context) throws IOException, InterruptedException {
        int count = 0;
        PmidMapping firstRecord = null;
        for (AvroValue<PmidMapping> value : values) {
            if (count == 0) {
                firstRecord = (PmidMapping)value.datum();
            }
            if (value.datum() != null && ENTITY_TYPE_RESEARCH_ARTICLE.equals(((PmidMapping)value.datum()).getEntityType())) {
                context.write((Object)new AvroKey((Object)IdentifierMapping.newBuilder().setOriginalId(((PmidMapping)value.datum()).getPmId()).setNewId(((PmidMapping)value.datum()).getOaId()).build()), (Object)NullWritable.get());
                return;
            }
            ++count;
        }
        if (count == 1) {
            context.write((Object)new AvroKey((Object)IdentifierMapping.newBuilder().setOriginalId(firstRecord.getPmId()).setNewId(firstRecord.getOaId()).build()), (Object)NullWritable.get());
        }
    }
}

