/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.core;

import eu.dnetlib.data.collective.transformation.core.schema.SchemaElement;
import eu.dnetlib.data.collective.transformation.core.schema.SchemaInspector;
import eu.dnetlib.data.collective.transformation.core.xsl.XslConstructor;
import eu.dnetlib.data.collective.transformation.core.xsl.XslElement;
import eu.dnetlib.data.collective.transformation.rulelanguage.IRule;
import eu.dnetlib.data.collective.transformation.rulelanguage.RuleLanguageParser;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.Converter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StylesheetBuilder {
    private static final Log log = LogFactory.getLog(StylesheetBuilder.class);
    private SchemaInspector schemaInspector;
    private RuleLanguageParser ruleLanguageParser;
    private NamespaceContext namespaceContext;
    private final String elementNameIndicatingDeletedRecords = "header";
    private final String attributeNameIndicatingDeletedRecords = "status";
    private final String attributeValueIndicatingDeletedRecords = "deleted";

    public String createTemplate() {
        if (this.schemaInspector == null || this.ruleLanguageParser == null || this.namespaceContext == null) {
            throw new IllegalStateException("StylesheetBuidler is not initialized with schemaInspector or ruleLanguageParser or namespaceContext.");
        }
        if (!this.schemaInspector.isInspected()) {
            throw new IllegalStateException("schemaInspector must first inspect in order to create a stylesheet.");
        }
        StringBuilder builder = new StringBuilder();
        XslElement templateRoot = new XslElement("templateroot");
        templateRoot.addBoundPrefix("xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
        templateRoot.addAllBoundPrefixes(Converter.getBoundPrefixes(this.ruleLanguageParser.getNamespaceDeclarations()));
        XslElement template = new XslElement("xsl:template");
        template.addAttribute("match", "/");
        Map<String, Set<IRule>> ruleMapping = this.ruleLanguageParser.getElementMappingRules();
        Map<String, IRule> variableRuleMapping = this.ruleLanguageParser.getVariableMappingRules();
        Map<String, IRule> templateRuleMapping = this.ruleLanguageParser.getTemplateMappingRules();
        LinkedList<String> templateQueue = new LinkedList<String>();
        XslElement rootField = new XslElement(this.schemaInspector.getRootElement());
        XslConstructor xslConstructor = new XslConstructor();
        int templateCounter = 1;
        int standaloneTemplateCounter = 1;
        for (String variable : variableRuleMapping.keySet()) {
            IRule currentVariableRule = variableRuleMapping.get(variable);
            templateRoot.addEnclosedElements(xslConstructor.writeOutVariableRule((Rules)currentVariableRule));
        }
        LinkedHashMap<String, String> targetFieldTemplateMap = new LinkedHashMap<String, String>();
        for (String keyTemplate : templateRuleMapping.keySet()) {
            IRule currentTemplateRule = templateRuleMapping.get(keyTemplate);
            targetFieldTemplateMap.put(((Rules)currentTemplateRule).getFunctionCall().getParameters().get("elementName"), "templName" + standaloneTemplateCounter);
            templateRoot.addEnclosedElements(xslConstructor.writeOutRecursiveTemplate((Rules)currentTemplateRule, "templName" + standaloneTemplateCounter++, this.ruleLanguageParser.getNamespaceDeclarations()).asXml());
        }
        XslElement chooseField = new XslElement("xsl:choose");
        XslElement whenField = new XslElement("xsl:when", "test", "//" + this.elementNameIndicatingDeletedRecords + "/@" + this.attributeNameIndicatingDeletedRecords + "='" + this.attributeValueIndicatingDeletedRecords + "'");
        XslElement otherwiseField = new XslElement("xsl:otherwise");
        for (SchemaElement element : this.schemaInspector.getChildElements()) {
            if (element.containsSimpleType()) continue;
            String complexTypeTemplateName = "apply" + templateCounter++;
            XslElement complexTypeTemplate = new XslElement("xsl:template", "name", complexTypeTemplateName);
            XslElement childField = new XslElement("xsl:element", "name", element.getName());
            if (element.getName().equals(this.elementNameIndicatingDeletedRecords)) {
                XslElement ifField = new XslElement("xsl:if", "test", "//" + this.elementNameIndicatingDeletedRecords + "/@" + this.attributeNameIndicatingDeletedRecords);
                XslElement attributeField = new XslElement("xsl:attribute", "name", this.attributeNameIndicatingDeletedRecords);
                XslElement valueofField = new XslElement("xsl:value-of", "select", "//" + this.elementNameIndicatingDeletedRecords + "/@" + this.attributeNameIndicatingDeletedRecords);
                attributeField.addEnclosedElements(valueofField.asXml());
                ifField.addEnclosedElements(attributeField.asXml());
                childField.addEnclosedElements(ifField.asXml());
            }
            for (SchemaElement childElement : element.getChildList()) {
                XslElement subTemplate;
                String templateName;
                String currentKey = this.getPrefixedElementName(childElement);
                if (childElement.containsSimpleType()) {
                    log.debug((Object)("currentKey: " + currentKey));
                    if (ruleMapping.containsKey(currentKey)) {
                        for (IRule currentRule : ruleMapping.get(currentKey)) {
                            if (!(currentRule instanceof Rules)) continue;
                            log.debug((Object)(" has Set? " + ((Rules)currentRule).hasSet()));
                            log.debug((Object)(" has Condition? " + ((Rules)currentRule).hasCondition()));
                            if (!((Rules)currentRule).hasCondition()) {
                                if (!((Rules)currentRule).hasSet()) {
                                    if (currentRule.definesTemplateMatch()) {
                                        templateName = ((Rules)currentRule).getTemplateMatch();
                                        subTemplate = new XslElement("xsl:template", "match", templateName);
                                        subTemplate.addEnclosedElements(xslConstructor.writeOutRuleCopy((Rules)currentRule, currentKey));
                                        templateQueue.add(subTemplate.asXml());
                                        childField.addEnclosedElements(xslConstructor.writeOutApplyTemplates(((Rules)currentRule).getProperties().getProperty("applyTemplateSelectExpression")));
                                        continue;
                                    }
                                    childField.addEnclosedElements(xslConstructor.writeOutRule((Rules)currentRule, currentKey));
                                    continue;
                                }
                                childField.addEnclosedElements(xslConstructor.writeOutRuleComplex((Rules)currentRule, currentKey));
                                continue;
                            }
                            if (((Rules)currentRule).getCondition().isPrimary((Rules)currentRule) && ((Rules)currentRule).getUniqueName().equals(((Rules)currentRule).getCondition().getSecondaryRule().getUniqueName())) {
                                if (((Rules)currentRule).getCondition().getApplyExpression() != null) {
                                    templateName = "apply" + templateCounter++;
                                    subTemplate = new XslElement("xsl:template", "name", templateName);
                                    subTemplate.addEnclosedElements(xslConstructor.writeOutApplyConditionalTemplateChoose((Rules)currentRule));
                                    templateQueue.add(subTemplate.asXml());
                                    childField.addEnclosedElements(xslConstructor.writeOutCallTemplate(templateName));
                                    continue;
                                }
                                childField.addEnclosedElements(xslConstructor.writeOutConditionalChoose((Rules)currentRule));
                                continue;
                            }
                            if (((Rules)currentRule).getCondition().getPrimaryRule().getUniqueName().equals(((Rules)currentRule).getCondition().getSecondaryRule().getUniqueName())) continue;
                            if (((Rules)currentRule).getCondition().getApplyExpression() != null) {
                                templateName = "apply" + templateCounter++;
                                subTemplate = new XslElement("xsl:template", "name", templateName);
                                subTemplate.addEnclosedElements(xslConstructor.writeOutApplyConditionalTemplateIf((Rules)currentRule, false));
                                templateQueue.add(subTemplate.asXml());
                                childField.addEnclosedElements(xslConstructor.writeOutCallTemplate(templateName));
                                continue;
                            }
                            childField.addEnclosedElements(xslConstructor.writeOutConditionalIf((Rules)currentRule));
                        }
                        continue;
                    }
                    if (targetFieldTemplateMap.containsKey(currentKey)) {
                        childField.addEnclosedElements(xslConstructor.writeOutCallTemplate((String)targetFieldTemplateMap.get(currentKey)));
                        continue;
                    }
                    if (!childElement.isMandatory()) continue;
                    XslElement emptyField = new XslElement(currentKey);
                    childField.addEnclosedElements(emptyField.asXml());
                    continue;
                }
                if (!ruleMapping.containsKey(currentKey)) continue;
                for (IRule currentRule : ruleMapping.get(currentKey)) {
                    if (!(currentRule instanceof Rules)) continue;
                    if (!((Rules)currentRule).hasCondition()) {
                        log.debug((Object)("stylesheetbuilder.complexType NO CONDITION: " + childElement.getName()));
                        childField.addEnclosedElements(xslConstructor.writeOutRuleComplex((Rules)currentRule, currentKey));
                        continue;
                    }
                    if (((Rules)currentRule).getCondition().isPrimary((Rules)currentRule) && ((Rules)currentRule).getUniqueName().equals(((Rules)currentRule).getCondition().getSecondaryRule().getUniqueName())) {
                        if (((Rules)currentRule).getCondition().getApplyExpression() != null) {
                            log.debug((Object)"APPLY expression rules for complex-type elements NOT YET SUPPORTED");
                            continue;
                        }
                        childField.addEnclosedElements(xslConstructor.writeOutConditionalChooseComplex((Rules)currentRule));
                        continue;
                    }
                    if (((Rules)currentRule).getCondition().getPrimaryRule().getUniqueName().equals(((Rules)currentRule).getCondition().getSecondaryRule().getUniqueName())) continue;
                    log.debug((Object)"CURRENTLY UNSUPPORTED!!!");
                    if (((Rules)currentRule).getCondition().getApplyExpression() != null) {
                        log.debug((Object)"APPLY expression rules for complex-type elements NOT YET SUPPORTED");
                        templateName = "apply" + templateCounter++;
                        subTemplate = new XslElement("xsl:template", "name", templateName);
                        subTemplate.addEnclosedElements(xslConstructor.writeOutApplyConditionalTemplateIf((Rules)currentRule, true));
                        templateQueue.add(subTemplate.asXml());
                        childField.addEnclosedElements(xslConstructor.writeOutCallTemplate(templateName));
                        continue;
                    }
                    childField.addEnclosedElements(xslConstructor.writeOutConditionalIfComplex((Rules)currentRule));
                }
            }
            if (childField.isEmpty() && !element.isMandatory()) continue;
            complexTypeTemplate.addEnclosedElements(childField.asXml());
            templateQueue.add(complexTypeTemplate.asXml());
            if (element.getName().equals(this.elementNameIndicatingDeletedRecords)) {
                whenField.addEnclosedElements(xslConstructor.writeOutCallTemplate(complexTypeTemplateName));
            }
            otherwiseField.addEnclosedElements(xslConstructor.writeOutCallTemplate(complexTypeTemplateName));
        }
        chooseField.addEnclosedElements(whenField.asXml());
        chooseField.addEnclosedElements(otherwiseField.asXml());
        rootField.addEnclosedElements(chooseField.asXml());
        template.addEnclosedElements(rootField.asXml());
        templateRoot.addEnclosedElements(template.asXml());
        for (String templateCode : templateQueue) {
            templateRoot.addEnclosedElements(templateCode);
        }
        builder.append(templateRoot.asXml());
        log.debug((Object)this.dumpStylesheetTemplate(builder.toString()));
        return builder.toString();
    }

    String dumpStylesheetTemplate(String aTemplate) {
        StringWriter w = new StringWriter();
        StreamSource s = new StreamSource(new StringReader(aTemplate));
        StreamResult r = new StreamResult(w);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            t.transform(s, r);
        }
        catch (Exception e) {
            log.fatal((Object)e);
        }
        return w.toString();
    }

    public void setSchemaInspector(SchemaInspector schemaInspector) {
        this.schemaInspector = schemaInspector;
    }

    public SchemaInspector getSchemaInspector() {
        return this.schemaInspector;
    }

    public RuleLanguageParser getRuleLanguageParser() {
        return this.ruleLanguageParser;
    }

    public void setRuleLanguageParser(RuleLanguageParser ruleLanguageParser) {
        this.ruleLanguageParser = ruleLanguageParser;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private String getPrefixedElementName(SchemaElement aElement) {
        return this.namespaceContext.getPrefix(aElement.getTargetNamespace()) + ":" + aElement.getName();
    }
}

