/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.engine.functions.Vocabulary;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.oro.text.perl.Perl5Util;

public class DateVocabulary
extends Vocabulary {
    private static final String filterFuncMin = "min()";
    private String pattern_1 = "/^(\\d{4,4}-\\d{2,2}-\\d{2,2})/";
    private String pattern_2 = "/^(\\d{4,4}-\\d{2,2})$/";
    private String pattern_3 = "/^(\\d{4,4})$/";
    private String pattern_4 = "/^(\\d{2,2}.\\d{2,2}.\\d{4,4})$/";
    private SimpleDateFormat df;
    private transient Perl5Util perl5 = new Perl5Util();

    @Override
    public String encoding(List<String> aKeys) throws ProcessingException {
        String tempKey_1 = null;
        String tempKey_2 = null;
        String tempKey_3 = null;
        String currentKey = null;
        try {
            Iterator<String> i$ = aKeys.iterator();
            while (i$.hasNext()) {
                String[] components;
                String key;
                currentKey = key = i$.next();
                if (this.perl5.match(this.pattern_1, key)) {
                    return this.perl5.getMatch().toString();
                }
                if (this.perl5.match(this.pattern_2, key)) {
                    tempKey_1 = key + "-01";
                    continue;
                }
                if (this.perl5.match(this.pattern_3, key)) {
                    tempKey_2 = key + "-01-01";
                    continue;
                }
                if (!this.perl5.match(this.pattern_4, key) || (components = key.split("[\\-\\/\\.]")).length < 3) continue;
                tempKey_3 = components[2] + "-" + components[1] + "-" + components[0];
            }
        }
        catch (Throwable e) {
            throw new ProcessingException("Exception thrown in Datevocabulary (tried to match for value '" + currentKey + "'):", e);
        }
        if (tempKey_1 != null) {
            return tempKey_1;
        }
        if (tempKey_2 != null) {
            return tempKey_2;
        }
        if (tempKey_3 != null) {
            return tempKey_3;
        }
        return "";
    }

    @Override
    public List<String> encoding(List<String> aKeys, String aDefaultPattern, String aFilterFunction) throws ProcessingException {
        LinkedList<String> evList = new LinkedList<String>();
        this.df = new SimpleDateFormat(aDefaultPattern);
        for (String v : aKeys) {
            String ev = this.encoding(Arrays.asList(v));
            if (ev.length() <= 0) continue;
            try {
                if (aFilterFunction.trim().length() > 0 && !evList.isEmpty()) {
                    evList.add(this.filter(this.df.parse(ev), this.df.parse((String)evList.remove(0)), aFilterFunction));
                    continue;
                }
                evList.add(this.df.format(this.df.parse(ev)));
            }
            catch (ParseException e) {
                throw new ProcessingException("invalid date format: " + ev);
            }
        }
        return evList;
    }

    private String filter(Date d1, Date d2, String filter) throws ProcessingException {
        if (filter.equals(filterFuncMin)) {
            if (d1.before(d2)) {
                return this.df.format(d1);
            }
            return this.df.format(d2);
        }
        throw new ProcessingException("unsupported filter function: " + filter);
    }
}

