/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdentifierExtract
extends AbstractTransformationFunction {
    public static final Log log = LogFactory.getLog(IdentifierExtract.class);
    public static final String paramXpathExprJson = "xpathExprJson";
    public static final String paramXpathExprInSource = "xpathExprInputSource";
    public static final String paramRegExpr = "regExpr";

    @Override
    String execute() throws ProcessingException {
        return null;
    }

    public NodeList extract(List<String> aXpathExprList, Node aInput, String aRegExpression, Document aDocument, XPath aXpath) throws ProcessingException {
        log.debug((Object)("xpathExprList: " + aXpathExprList));
        log.debug((Object)("regExpr: " + aRegExpression));
        HashSet<String> identifierSet = new HashSet<String>();
        log.debug((Object)("regular expression : " + aRegExpression));
        Pattern p = Pattern.compile(aRegExpression);
        try {
            List<String> textList = this.extractText(aXpathExprList, aInput, aXpath);
            for (String text : textList) {
                log.debug((Object)("text as input : " + text));
                Matcher m = p.matcher(text);
                while (m.find()) {
                    log.debug((Object)("extracted identifier: " + m.group()));
                    identifierSet.add(m.group());
                }
            }
            return this.toNodeList(identifierSet, aDocument);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new ProcessingException(e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new ProcessingException(e);
        }
    }

    private NodeList toNodeList(Set<String> aValueSet, Document aDocument) {
        DocumentFragment dFrag = aDocument.createDocumentFragment();
        Element root = aDocument.createElement("root");
        dFrag.appendChild(root);
        for (String value : aValueSet) {
            Element eVal = aDocument.createElement("value");
            eVal.setTextContent(value);
            root.appendChild(eVal);
        }
        return dFrag.getChildNodes();
    }

    private List<String> extractText(List<String> aXpathExprList, Node aInput, XPath aXpath) throws XPathExpressionException, ParserConfigurationException {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String xpathExpr : aXpathExprList) {
            NodeList nodeList = (NodeList)aXpath.evaluate(xpathExpr, aInput, XPathConstants.NODESET);
            log.debug((Object)("extract text: nodelist length: " + nodeList.getLength()));
            for (int i = 0; i < nodeList.getLength(); ++i) {
                resultList.add(nodeList.item(i).getTextContent());
            }
        }
        return resultList;
    }
}

